/************************************************************************************************/
/* Stata User File for H181 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H181.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H181.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H181.DO                                               */
/* The program below will output the Stata dataset H181.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL 17-18
  str    FAMID31 19-20
  str    FAMID42 21-22
  str    FAMID53 23-24
  str    FAMID15 25-26
  str    FAMIDYR 27-28
  str    CPSFAMID 29-30
  byte   FCSZ1231 31-32
  byte   FCRP1231 33-34
  str    RULETR31 35-36
  str    RULETR42 37-38
  str    RULETR53 39-40
  str    RULETR15 41-42
  byte   RUSIZE31 43-44
  byte   RUSIZE42 45-46
  byte   RUSIZE53 47-48
  byte   RUSIZE15 49-50
  byte   RUCLAS31 51-52
  byte   RUCLAS42 53-54
  byte   RUCLAS53 55-56
  byte   RUCLAS15 57-57
  byte   FAMSZE31 58-59
  byte   FAMSZE42 60-61
  byte   FAMSZE53 62-63
  byte   FAMSZE15 64-65
  byte   FMRS1231 66-67
  byte   FAMS1231 68-69
  byte   FAMSZEYR 70-71
  byte   FAMRFPYR 72-72
  byte   REGION31 73-74
  byte   REGION42 75-76
  byte   REGION53 77-78
  byte   REGION15 79-80
  int    REFPRS31 81-83
  int    REFPRS42 84-86
  int    REFPRS53 87-89
  int    REFPRS15 90-92
  byte   RESP31 93-93
  byte   RESP42 94-94
  byte   RESP53 95-95
  byte   RESP15 96-96
  byte   PROXY31 97-98
  byte   PROXY42 99-100
  byte   PROXY53 101-102
  byte   PROXY15 103-103
  byte   INTVLANG 104-105
  byte   BEGRFM31 106-107
  int    BEGRFY31 108-111
  byte   ENDRFM31 112-113
  int    ENDRFY31 114-117
  byte   BEGRFM42 118-119
  int    BEGRFY42 120-123
  byte   ENDRFM42 124-125
  int    ENDRFY42 126-129
  byte   BEGRFM53 130-131
  int    BEGRFY53 132-135
  byte   ENDRFM53 136-137
  int    ENDRFY53 138-141
  byte   ENDRFM15 142-143
  int    ENDRFY15 144-147
  byte   KEYNESS 148-148
  byte   INSCOP31 149-149
  byte   INSCOP42 150-150
  byte   INSCOP53 151-151
  byte   INSCOP15 152-152
  byte   INSC1231 153-153
  byte   INSCOPE 154-154
  byte   ELGRND31 155-155
  byte   ELGRND42 156-156
  byte   ELGRND53 157-157
  byte   ELGRND15 158-158
  byte   PSTATS31 159-160
  byte   PSTATS42 161-162
  byte   PSTATS53 163-164
  str    RURSLT31 165-166
  str    RURSLT42 167-168
  str    RURSLT53 169-170
  byte   AGE31X 171-172
  byte   AGE42X 173-174
  byte   AGE53X 175-176
  byte   AGE15X 177-178
  byte   AGELAST 179-180
  byte   DOBMM 181-182
  int    DOBYY 183-186
  byte   SEX 187-187
  byte   RACEV1X 188-188
  byte   RACEV2X 189-190
  byte   RACEAX 191-191
  byte   RACEBX 192-192
  byte   RACEWX 193-193
  byte   RACETHX 194-194
  byte   HISPANX 195-195
  byte   HISPNCAT 196-196
  byte   MARRY31X 197-198
  byte   MARRY42X 199-200
  byte   MARRY53X 201-202
  byte   MARRY15X 203-204
  int    SPOUID31 205-207
  int    SPOUID42 208-210
  int    SPOUID53 211-213
  int    SPOUID15 214-216
  byte   SPOUIN31 217-218
  byte   SPOUIN42 219-220
  byte   SPOUIN53 221-222
  byte   SPOUIN15 223-224
  byte   EDUYRDG 225-226
  byte   EDUCYR 227-228
  byte   HIDEG 229-230
  byte   EDRECODE 231-232
  byte   FTSTU31X 233-234
  byte   FTSTU42X 235-236
  byte   FTSTU53X 237-238
  byte   FTSTU15X 239-240
  byte   ACTDTY31 241-242
  byte   ACTDTY42 243-244
  byte   ACTDTY53 245-246
  byte   HONRDC31 247-248
  byte   HONRDC42 249-250
  byte   HONRDC53 251-252
  byte   REFRL31X 253-254
  byte   REFRL42X 255-256
  byte   REFRL53X 257-258
  byte   REFRL15X 259-260
  byte   OTHLANG 261-262
  byte   LANGSPK 263-264
  byte   HWELLSPE 265-266
  byte   BORNUSA 267-268
  byte   YRSINUS 269-270
  int    MOPID31X 271-273
  int    MOPID42X 274-276
  int    MOPID53X 277-279
  int    DAPID31X 280-282
  int    DAPID42X 283-285
  int    DAPID53X 286-288
  byte   RTHLTH31 289-290
  byte   RTHLTH42 291-292
  byte   RTHLTH53 293-294
  byte   MNHLTH31 295-296
  byte   MNHLTH42 297-298
  byte   MNHLTH53 299-300
  byte   HIBPDX 301-302
  byte   HIBPAGED 303-304
  byte   BPMLDX 305-306
  byte   CHDDX 307-308
  byte   CHDAGED 309-310
  byte   ANGIDX 311-312
  byte   ANGIAGED 313-314
  byte   MIDX 315-316
  byte   MIAGED 317-318
  byte   OHRTDX 319-320
  byte   OHRTAGED 321-322
  byte   STRKDX 323-324
  byte   STRKAGED 325-326
  byte   EMPHDX 327-328
  byte   EMPHAGED 329-330
  byte   CHBRON31 331-332
  byte   CHBRON53 333-334
  byte   CHOLDX 335-336
  byte   CHOLAGED 337-338
  byte   CANCERDX 339-340
  byte   CABLADDR 341-342
  byte   CABREAST 343-344
  byte   CACERVIX 345-346
  byte   CACOLON 347-348
  byte   CALUNG 349-350
  byte   CALYMPH 351-352
  byte   CAMELANO 353-354
  byte   CAOTHER 355-356
  byte   CAPROSTA 357-358
  byte   CASKINNM 359-360
  byte   CASKINDK 361-362
  byte   CAUTERUS 363-364
  byte   DIABDX 365-366
  byte   DIABAGED 367-368
  byte   JTPAIN31 369-370
  byte   JTPAIN53 371-372
  byte   ARTHDX 373-374
  byte   ARTHTYPE 375-376
  byte   ARTHAGED 377-378
  byte   ASTHDX 379-380
  byte   ASTHAGED 381-382
  byte   ASSTIL31 383-384
  byte   ASSTIL53 385-386
  byte   ASATAK31 387-388
  byte   ASATAK53 389-390
  byte   ASTHEP31 391-392
  byte   ASTHEP53 393-394
  byte   ASACUT53 395-396
  byte   ASMRCN53 397-398
  byte   ASPREV53 399-400
  byte   ASDALY53 401-402
  byte   ASPKFL53 403-404
  byte   ASEVFL53 405-406
  byte   ASWNFL53 407-408
  byte   ADHDADDX 409-410
  byte   ADHDAGED 411-412
  byte   PREGNT31 413-414
  byte   PREGNT42 415-416
  byte   PREGNT53 417-418
  byte   IADLHP31 419-420
  byte   IADLHP53 421-422
  byte   ADLHLP31 423-424
  byte   ADLHLP53 425-426
  byte   AIDHLP31 427-428
  byte   AIDHLP53 429-430
  byte   WLKLIM31 431-432
  byte   WLKLIM53 433-434
  byte   LFTDIF31 435-436
  byte   LFTDIF53 437-438
  byte   STPDIF31 439-440
  byte   STPDIF53 441-442
  byte   WLKDIF31 443-444
  byte   WLKDIF53 445-446
  byte   MILDIF31 447-448
  byte   MILDIF53 449-450
  byte   STNDIF31 451-452
  byte   STNDIF53 453-454
  byte   BENDIF31 455-456
  byte   BENDIF53 457-458
  byte   RCHDIF31 459-460
  byte   RCHDIF53 461-462
  byte   FNGRDF31 463-464
  byte   FNGRDF53 465-466
  byte   ACTLIM31 467-468
  byte   ACTLIM53 469-470
  byte   WRKLIM31 471-472
  byte   WRKLIM53 473-474
  byte   HSELIM31 475-476
  byte   HSELIM53 477-478
  byte   SCHLIM31 479-480
  byte   SCHLIM53 481-482
  byte   UNABLE31 483-484
  byte   UNABLE53 485-486
  byte   SOCLIM31 487-488
  byte   SOCLIM53 489-490
  byte   COGLIM31 491-492
  byte   COGLIM53 493-494
  byte   DFHEAR42 495-496
  byte   DEAF42 497-498
  byte   DFSEE42 499-500
  byte   BLIND42 501-502
  byte   DFCOG42 503-504
  byte   DFWLKC42 505-506
  byte   DFDRSB42 507-508
  byte   DFERND42 509-510
  byte   HEARAD42 511-512
  byte   WRGLAS42 513-514
  byte   ANYLMT15 515-516
  byte   CHPMED42 517-518
  byte   CHPMHB42 519-520
  byte   CHPMCN42 521-522
  byte   CHSERV42 523-524
  byte   CHSRHB42 525-526
  byte   CHSRCN42 527-528
  byte   CHLIMI42 529-530
  byte   CHLIHB42 531-532
  byte   CHLICO42 533-534
  byte   CHTHER42 535-536
  byte   CHTHHB42 537-538
  byte   CHTHCO42 539-540
  byte   CHCOUN42 541-542
  byte   CHEMPB42 543-544
  byte   CSHCN42 545-546
  byte   MOMPRO42 547-548
  byte   DADPRO42 549-550
  byte   UNHAP42 551-552
  byte   SCHLBH42 553-554
  byte   HAVFUN42 555-556
  byte   ADUPRO42 557-558
  byte   NERVAF42 559-560
  byte   SIBPRO42 561-562
  byte   KIDPRO42 563-564
  byte   SPRPRO42 565-566
  byte   SCHPRO42 567-568
  byte   HOMEBH42 569-570
  byte   TRBLE42 571-572
  byte   CHILCR42 573-574
  byte   CHILWW42 575-576
  byte   CHRTCR42 577-578
  byte   CHRTWW42 579-580
  byte   CHAPPT42 581-582
  byte   CHNDCR42 583-584
  byte   CHENEC42 585-586
  byte   CHLIST42 587-588
  byte   CHEXPL42 589-590
  byte   CHRESP42 591-592
  byte   CHPRTM42 593-594
  byte   CHHECR42 595-596
  byte   CHSPEC42 597-598
  byte   CHEYRE42 599-600
  byte   MESHGT42 601-602
  byte   WHNHGT42 603-604
  byte   MESWGT42 605-606
  byte   WHNWGT42 607-608
  double CHBMIX42 609-612
  byte   MESVIS42 613-614
  byte   MESBPR42 615-616
  byte   WHNBPR42 617-618
  byte   DENTAL42 619-620
  byte   WHNDEN42 621-622
  byte   EATHLT42 623-624
  byte   WHNEAT42 625-626
  byte   PHYSCL42 627-628
  byte   WHNPHY42 629-630
  byte   SAFEST42 631-632
  byte   WHNSAF42 633-634
  byte   BOOST42 635-636
  byte   WHNBST42 637-638
  byte   LAPBLT42 639-640
  byte   WHNLAP42 641-642
  byte   HELMET42 643-644
  byte   WHNHEL42 645-646
  byte   NOSMOK42 647-648
  byte   WHNSMK42 649-650
  byte   TIMALN42 651-652
  byte   DENTCK53 653-654
  byte   BPCHEK53 655-656
  byte   CHOLCK53 657-658
  byte   CHECK53 659-660
  byte   NOFAT53 661-662
  byte   EXRCIS53 663-664
  byte   FLUSHT53 665-666
  byte   ASPRIN53 667-668
  byte   NOASPR53 669-670
  byte   STOMCH53 671-672
  byte   LSTETH53 673-674
  byte   PSA53 675-676
  byte   HYSTER53 677-678
  byte   PAPSMR53 679-680
  byte   BRSTEX53 681-682
  byte   MAMOGR53 683-684
  byte   BSTST53 685-686
  byte   BSTSRE53 687-688
  byte   CLNTST53 689-690
  byte   CLNTRE53 691-692
  byte   SGMTST53 693-694
  byte   SGMTRE53 695-696
  byte   PHYEXE53 697-698
  double BMINDX53 699-703
  byte   SEATBE53 704-705
  byte   SAQELIG 706-706
  int    ADPRXY42 707-709
  byte   ADILCR42 710-711
  byte   ADILWW42 712-713
  byte   ADRTCR42 714-715
  byte   ADRTWW42 716-717
  byte   ADAPPT42 718-719
  byte   ADNDCR42 720-721
  byte   ADEGMC42 722-723
  byte   ADLIST42 724-725
  byte   ADEXPL42 726-727
  byte   ADRESP42 728-729
  byte   ADPRTM42 730-731
  byte   ADINST42 732-733
  byte   ADEZUN42 734-735
  byte   ADTLHW42 736-737
  byte   ADFFRM42 738-739
  byte   ADFHLP42 740-741
  byte   ADHECR42 742-743
  byte   ADSMOK42 744-745
  byte   ADNSMK42 746-747
  byte   ADDRBP42 748-749
  byte   ADSPEC42 750-751
  byte   ADESSP42 752-753
  byte   ADGENH42 754-755
  byte   ADDAYA42 756-757
  byte   ADCLIM42 758-759
  byte   ADPALS42 760-761
  byte   ADPWLM42 762-763
  byte   ADMALS42 764-765
  byte   ADMWLM42 766-767
  byte   ADPAIN42 768-769
  byte   ADCAPE42 770-771
  byte   ADNRGY42 772-773
  byte   ADDOWN42 774-775
  byte   ADSOCA42 776-777
  double PCS42 778-782
  double MCS42 783-787
  byte   SFFLAG42 788-789
  byte   ADNERV42 790-791
  byte   ADHOPE42 792-793
  byte   ADREST42 794-795
  byte   ADSAD42 796-797
  byte   ADEFRT42 798-799
  byte   ADWRTH42 800-801
  byte   K6SUM42 802-803
  byte   ADINTR42 804-805
  byte   ADDPRS42 806-807
  byte   PHQ242 808-809
  byte   ADINSA42 810-811
  byte   ADINSB42 812-813
  byte   ADRISK42 814-815
  byte   ADOVER42 816-817
  byte   ADCMPM42 818-819
  int    ADCMPY42 820-823
  byte   ADLANG42 824-825
  byte   DSDIA53 826-827
  byte   DSA1C53 828-829
  byte   DSFT1653 830-831
  byte   DSFT1553 832-833
  byte   DSFT1453 834-835
  byte   DSFB1453 836-837
  byte   DSFTNV53 838-839
  byte   DSEY1653 840-841
  byte   DSEY1553 842-843
  byte   DSEY1453 844-845
  byte   DSEB1453 846-847
  byte   DSEYNV53 848-849
  byte   DSCH1653 850-851
  byte   DSCH1553 852-853
  byte   DSCH1453 854-855
  byte   DSCB1453 856-857
  byte   DSCHNV53 858-859
  byte   DSFL1653 860-861
  byte   DSFL1553 862-863
  byte   DSFL1453 864-865
  byte   DSVB1453 866-867
  byte   DSFLNV53 868-869
  byte   DSKIDN53 870-871
  byte   DSEYPR53 872-873
  byte   DSDIET53 874-875
  byte   DSMED53 876-877
  byte   DSINSU53 878-879
  byte   DSCPCP53 880-881
  byte   DSCNPC53 882-883
  byte   DSCPHN53 884-885
  byte   DSCINT53 886-887
  byte   DSCGRP53 888-889
  byte   DSCONF53 890-891
  byte   DSPRX53 892-893
  byte   DDNWRK15 894-895
  byte   DDNSCL15 896-897
  byte   OTHDYS15 898-899
  byte   OTHNDD15 900-901
  byte   ACCELI42 902-903
  byte   HAVEUS42 904-905
  byte   YNOUSC42 906-907
  byte   NOREAS42 908-909
  byte   SELDSI42 910-911
  byte   NEWARE42 912-913
  byte   DKWHRU42 914-915
  byte   USCNOT42 916-917
  byte   PERSLA42 918-919
  byte   DIFFPL42 920-921
  byte   INSRPL42 922-923
  byte   MYSELF42 924-925
  byte   CARECO42 926-927
  byte   NOHINS42 928-929
  byte   OTHINS42 930-931
  byte   JOBRSN42 932-933
  byte   NEWDOC42 934-935
  byte   DOCELS42 936-937
  byte   NOLIKE42 938-939
  byte   HEALTH42 940-941
  byte   KNOWDR42 942-943
  byte   ONJOB42 944-945
  byte   NOGODR42 946-947
  byte   TRANS42 948-949
  byte   CLINIC42 950-951
  byte   OTHREA42 952-953
  byte   PROVTY42 954-955
  byte   PLCTYP42 956-957
  byte   TMTKUS42 958-959
  byte   TYPEPE42 960-961
  byte   LOCATN42 962-963
  byte   HSPLAP42 964-965
  byte   WHITPR42 966-967
  byte   BLCKPR42 968-969
  byte   ASIANP42 970-971
  byte   NATAMP42 972-973
  byte   PACISP42 974-975
  byte   OTHRCP42 976-977
  byte   GENDRP42 978-979
  byte   MINORP42 980-981
  byte   PREVEN42 982-983
  byte   REFFRL42 984-985
  byte   ONGONG42 986-987
  byte   PHNREG42 988-989
  byte   OFFHOU42 990-991
  byte   AFTHOU42 992-993
  byte   TREATM42 994-995
  byte   RESPCT42 996-997
  byte   DECIDE42 998-999
  byte   EXPLOP42 1000-1001
  byte   PRVSPK42 1002-1003
  byte   MDUNAB42 1004-1005
  byte   MDUNRS42 1006-1007
  byte   MDDLAY42 1008-1009
  byte   MDDLRS42 1010-1011
  byte   DNUNAB42 1012-1013
  byte   DNUNRS42 1014-1015
  byte   DNDLAY42 1016-1017
  byte   DNDLRS42 1018-1019
  byte   PMUNAB42 1020-1021
  byte   PMUNRS42 1022-1023
  byte   PMDLAY42 1024-1025
  byte   PMDLRS42 1026-1027
  byte   RNDFLG31 1028-1029
  byte   MORJOB31 1030-1031
  byte   MORJOB42 1032-1033
  byte   MORJOB53 1034-1035
  byte   EVRWRK 1036-1037
  double HRWG31X 1038-1043
  double HRWG42X 1044-1049
  double HRWG53X 1050-1055
  byte   HRWGIM31 1056-1056
  byte   HRWGIM42 1057-1057
  byte   HRWGIM53 1058-1058
  byte   HRHOW31 1059-1060
  byte   HRHOW42 1061-1062
  byte   HRHOW53 1063-1064
  byte   DIFFWG31 1065-1066
  byte   DIFFWG42 1067-1068
  byte   DIFFWG53 1069-1070
  double NHRWG31 1071-1076
  double NHRWG42 1077-1082
  double NHRWG53 1083-1088
  int    HOUR31 1089-1091
  int    HOUR42 1092-1094
  int    HOUR53 1095-1097
  byte   TEMPJB31 1098-1099
  byte   TEMPJB42 1100-1101
  byte   TEMPJB53 1102-1103
  byte   SSNLJB31 1104-1105
  byte   SSNLJB42 1106-1107
  byte   SSNLJB53 1108-1109
  byte   SELFCM31 1110-1111
  byte   SELFCM42 1112-1113
  byte   SELFCM53 1114-1115
  byte   DISVW31X 1116-1117
  byte   DISVW42X 1118-1119
  byte   DISVW53X 1120-1121
  byte   CHOIC31 1122-1123
  byte   CHOIC42 1124-1125
  byte   CHOIC53 1126-1127
  byte   INDCAT31 1128-1129
  byte   INDCAT42 1130-1131
  byte   INDCAT53 1132-1133
  int    NUMEMP31 1134-1136
  int    NUMEMP42 1137-1139
  int    NUMEMP53 1140-1142
  byte   MORE31 1143-1144
  byte   MORE42 1145-1146
  byte   MORE53 1147-1148
  byte   UNION31 1149-1150
  byte   UNION42 1151-1152
  byte   UNION53 1153-1154
  byte   NWK31 1155-1156
  byte   NWK42 1157-1158
  byte   NWK53 1159-1160
  byte   CHGJ3142 1161-1162
  byte   CHGJ4253 1163-1164
  byte   YCHJ3142 1165-1166
  byte   YCHJ4253 1167-1168
  byte   STJBMM31 1169-1170
  int    STJBYY31 1171-1174
  byte   STJBMM42 1175-1176
  int    STJBYY42 1177-1180
  byte   STJBMM53 1181-1182
  int    STJBYY53 1183-1186
  byte   EVRETIRE 1187-1188
  byte   OCCCAT31 1189-1190
  byte   OCCCAT42 1191-1192
  byte   OCCCAT53 1193-1194
  byte   PAYVAC31 1195-1196
  byte   PAYVAC42 1197-1198
  byte   PAYVAC53 1199-1200
  byte   SICPAY31 1201-1202
  byte   SICPAY42 1203-1204
  byte   SICPAY53 1205-1206
  byte   PAYDR31 1207-1208
  byte   PAYDR42 1209-1210
  byte   PAYDR53 1211-1212
  byte   RETPLN31 1213-1214
  byte   RETPLN42 1215-1216
  byte   RETPLN53 1217-1218
  byte   BSNTY31 1219-1220
  byte   BSNTY42 1221-1222
  byte   BSNTY53 1223-1224
  byte   JOBORG31 1225-1226
  byte   JOBORG42 1227-1228
  byte   JOBORG53 1229-1230
  byte   HELD31X 1231-1232
  byte   HELD42X 1233-1234
  byte   HELD53X 1235-1236
  byte   OFFER31X 1237-1238
  byte   OFFER42X 1239-1240
  byte   OFFER53X 1241-1242
  byte   OFREMP31 1243-1244
  byte   OFREMP42 1245-1246
  byte   OFREMP53 1247-1248
  byte   EMPST31 1249-1250
  byte   EMPST42 1251-1252
  byte   EMPST53 1253-1254
  byte   EMPST31H 1255-1256
  byte   EMPST42H 1257-1258
  byte   EMPST53H 1259-1260
  byte   SLFCM31H 1261-1262
  byte   SLFCM42H 1263-1264
  byte   SLFCM53H 1265-1266
  int    NMEMP31H 1267-1269
  int    NMEMP42H 1270-1272
  int    NMEMP53H 1273-1275
  byte   MORE31H 1276-1277
  byte   MORE42H 1278-1279
  byte   MORE53H 1280-1281
  byte   INDCT31H 1282-1283
  byte   INDCT42H 1284-1285
  byte   INDCT53H 1286-1287
  byte   OCCCT31H 1288-1289
  byte   OCCCT42H 1290-1291
  byte   OCCCT53H 1292-1293
  int    HOUR31H 1294-1296
  int    HOUR42H 1297-1299
  int    HOUR53H 1300-1302
  byte   JBORG31H 1303-1304
  byte   JBORG42H 1305-1306
  byte   JBORG53H 1307-1308
  byte   UNION31H 1309-1310
  byte   UNION42H 1311-1312
  byte   UNION53H 1313-1314
  byte   BSNTY31H 1315-1316
  byte   BSNTY42H 1317-1318
  byte   BSNTY53H 1319-1320
  double HRWG31H 1321-1326
  double HRWG42H 1327-1332
  double HRWG53H 1333-1338
  byte   CMJHLD31 1339-1340
  byte   CMJHLD42 1341-1342
  byte   CMJHLD53 1343-1344
  byte   OFFER31H 1345-1346
  byte   OFFER42H 1347-1348
  byte   OFFER53H 1349-1350
  byte   OFEMP31H 1351-1352
  byte   OFEMP42H 1353-1354
  byte   OFEMP53H 1355-1356
  byte   PYVAC31H 1357-1358
  byte   PYVAC42H 1359-1360
  byte   PYVAC53H 1361-1362
  byte   SCPAY31H 1363-1364
  byte   SCPAY42H 1365-1366
  byte   SCPAY53H 1367-1368
  byte   PAYDR31H 1369-1370
  byte   PAYDR42H 1371-1372
  byte   PAYDR53H 1373-1374
  byte   RTPLN31H 1375-1376
  byte   RTPLN42H 1377-1378
  byte   RTPLN53H 1379-1380
  byte   AFDC15 1381-1382
  byte   FILEDR15 1383-1384
  byte   WILFIL15 1385-1386
  byte   FLSTAT15 1387-1388
  byte   FILER15 1389-1390
  byte   JTINRU15 1391-1392
  int    JNTPID15 1393-1395
  byte   CLMDEP15 1396-1397
  byte   DEPDNT15 1398-1399
  byte   DPINRU15 1400-1401
  byte   DPOTSD15 1402-1403
  byte   TAXFRM15 1404-1405
  byte   CLMHIP15 1406-1407
  byte   EICRDT15 1408-1409
  byte   FOODST15 1410-1411
  byte   FOODMN15 1412-1413
  int    FOODVL15 1414-1417
  long   TTLP15X 1418-1424
  long   FAMINC15 1425-1431
  byte   POVCAT15 1432-1432
  double POVLEV15 1433-1443
  long   WAGEP15X 1444-1449
  byte   WAGIMP15 1450-1450
  long   BUSNP15X 1451-1456
  byte   BUSIMP15 1457-1457
  int    UNEMP15X 1458-1461
  byte   UNEIMP15 1462-1462
  long   WCMPP15X 1463-1467
  byte   WCPIMP15 1468-1468
  long   INTRP15X 1469-1473
  byte   INTIMP15 1474-1474
  long   DIVDP15X 1475-1479
  byte   DIVIMP15 1480-1480
  long   SALEP15X 1481-1487
  byte   SALIMP15 1488-1488
  long   PENSP15X 1489-1494
  byte   PENIMP15 1495-1495
  long   SSECP15X 1496-1500
  byte   SSCIMP15 1501-1501
  long   TRSTP15X 1502-1508
  byte   TRTIMP15 1509-1509
  long   VETSP15X 1510-1514
  byte   VETIMP15 1515-1515
  long   IRASP15X 1516-1521
  byte   IRAIMP15 1522-1522
  long   ALIMP15X 1523-1527
  byte   ALIIMP15 1528-1528
  long   CHLDP15X 1529-1533
  byte   CHLIMP15 1534-1534
  long   CASHP15X 1535-1540
  byte   CSHIMP15 1541-1541
  long   SSIP15X 1542-1546
  byte   SSIIMP15 1547-1547
  int    PUBP15X 1548-1551
  byte   PUBIMP15 1552-1552
  long   OTHRP15X 1553-1558
  byte   OTHIMP15 1559-1559
  str    HIEUIDX 1560-1566
  byte   TRIJA15X 1567-1568
  byte   TRIFE15X 1569-1570
  byte   TRIMA15X 1571-1572
  byte   TRIAP15X 1573-1574
  byte   TRIMY15X 1575-1576
  byte   TRIJU15X 1577-1578
  byte   TRIJL15X 1579-1580
  byte   TRIAU15X 1581-1582
  byte   TRISE15X 1583-1584
  byte   TRIOC15X 1585-1586
  byte   TRINO15X 1587-1588
  byte   TRIDE15X 1589-1590
  byte   MCRJA15 1591-1592
  byte   MCRFE15 1593-1594
  byte   MCRMA15 1595-1596
  byte   MCRAP15 1597-1598
  byte   MCRMY15 1599-1600
  byte   MCRJU15 1601-1602
  byte   MCRJL15 1603-1604
  byte   MCRAU15 1605-1606
  byte   MCRSE15 1607-1608
  byte   MCROC15 1609-1610
  byte   MCRNO15 1611-1612
  byte   MCRDE15 1613-1614
  byte   MCRJA15X 1615-1616
  byte   MCRFE15X 1617-1618
  byte   MCRMA15X 1619-1620
  byte   MCRAP15X 1621-1622
  byte   MCRMY15X 1623-1624
  byte   MCRJU15X 1625-1626
  byte   MCRJL15X 1627-1628
  byte   MCRAU15X 1629-1630
  byte   MCRSE15X 1631-1632
  byte   MCROC15X 1633-1634
  byte   MCRNO15X 1635-1636
  byte   MCRDE15X 1637-1638
  byte   MCDJA15 1639-1640
  byte   MCDFE15 1641-1642
  byte   MCDMA15 1643-1644
  byte   MCDAP15 1645-1646
  byte   MCDMY15 1647-1648
  byte   MCDJU15 1649-1650
  byte   MCDJL15 1651-1652
  byte   MCDAU15 1653-1654
  byte   MCDSE15 1655-1656
  byte   MCDOC15 1657-1658
  byte   MCDNO15 1659-1660
  byte   MCDDE15 1661-1662
  byte   MCDJA15X 1663-1664
  byte   MCDFE15X 1665-1666
  byte   MCDMA15X 1667-1668
  byte   MCDAP15X 1669-1670
  byte   MCDMY15X 1671-1672
  byte   MCDJU15X 1673-1674
  byte   MCDJL15X 1675-1676
  byte   MCDAU15X 1677-1678
  byte   MCDSE15X 1679-1680
  byte   MCDOC15X 1681-1682
  byte   MCDNO15X 1683-1684
  byte   MCDDE15X 1685-1686
  byte   OPAJA15 1687-1688
  byte   OPAFE15 1689-1690
  byte   OPAMA15 1691-1692
  byte   OPAAP15 1693-1694
  byte   OPAMY15 1695-1696
  byte   OPAJU15 1697-1698
  byte   OPAJL15 1699-1700
  byte   OPAAU15 1701-1702
  byte   OPASE15 1703-1704
  byte   OPAOC15 1705-1706
  byte   OPANO15 1707-1708
  byte   OPADE15 1709-1710
  byte   OPBJA15 1711-1712
  byte   OPBFE15 1713-1714
  byte   OPBMA15 1715-1716
  byte   OPBAP15 1717-1718
  byte   OPBMY15 1719-1720
  byte   OPBJU15 1721-1722
  byte   OPBJL15 1723-1724
  byte   OPBAU15 1725-1726
  byte   OPBSE15 1727-1728
  byte   OPBOC15 1729-1730
  byte   OPBNO15 1731-1732
  byte   OPBDE15 1733-1734
  byte   STAJA15 1735-1736
  byte   STAFE15 1737-1738
  byte   STAMA15 1739-1740
  byte   STAAP15 1741-1742
  byte   STAMY15 1743-1744
  byte   STAJU15 1745-1746
  byte   STAJL15 1747-1748
  byte   STAAU15 1749-1750
  byte   STASE15 1751-1752
  byte   STAOC15 1753-1754
  byte   STANO15 1755-1756
  byte   STADE15 1757-1758
  byte   PUBJA15X 1759-1760
  byte   PUBFE15X 1761-1762
  byte   PUBMA15X 1763-1764
  byte   PUBAP15X 1765-1766
  byte   PUBMY15X 1767-1768
  byte   PUBJU15X 1769-1770
  byte   PUBJL15X 1771-1772
  byte   PUBAU15X 1773-1774
  byte   PUBSE15X 1775-1776
  byte   PUBOC15X 1777-1778
  byte   PUBNO15X 1779-1780
  byte   PUBDE15X 1781-1782
  byte   PEGJA15 1783-1784
  byte   PEGFE15 1785-1786
  byte   PEGMA15 1787-1788
  byte   PEGAP15 1789-1790
  byte   PEGMY15 1791-1792
  byte   PEGJU15 1793-1794
  byte   PEGJL15 1795-1796
  byte   PEGAU15 1797-1798
  byte   PEGSE15 1799-1800
  byte   PEGOC15 1801-1802
  byte   PEGNO15 1803-1804
  byte   PEGDE15 1805-1806
  byte   PDKJA15 1807-1808
  byte   PDKFE15 1809-1810
  byte   PDKMA15 1811-1812
  byte   PDKAP15 1813-1814
  byte   PDKMY15 1815-1816
  byte   PDKJU15 1817-1818
  byte   PDKJL15 1819-1820
  byte   PDKAU15 1821-1822
  byte   PDKSE15 1823-1824
  byte   PDKOC15 1825-1826
  byte   PDKNO15 1827-1828
  byte   PDKDE15 1829-1830
  byte   PNGJA15 1831-1832
  byte   PNGFE15 1833-1834
  byte   PNGMA15 1835-1836
  byte   PNGAP15 1837-1838
  byte   PNGMY15 1839-1840
  byte   PNGJU15 1841-1842
  byte   PNGJL15 1843-1844
  byte   PNGAU15 1845-1846
  byte   PNGSE15 1847-1848
  byte   PNGOC15 1849-1850
  byte   PNGNO15 1851-1852
  byte   PNGDE15 1853-1854
  byte   POGJA15 1855-1856
  byte   POGFE15 1857-1858
  byte   POGMA15 1859-1860
  byte   POGAP15 1861-1862
  byte   POGMY15 1863-1864
  byte   POGJU15 1865-1866
  byte   POGJL15 1867-1868
  byte   POGAU15 1869-1870
  byte   POGSE15 1871-1872
  byte   POGOC15 1873-1874
  byte   POGNO15 1875-1876
  byte   POGDE15 1877-1878
  byte   PRSJA15 1879-1880
  byte   PRSFE15 1881-1882
  byte   PRSMA15 1883-1884
  byte   PRSAP15 1885-1886
  byte   PRSMY15 1887-1888
  byte   PRSJU15 1889-1890
  byte   PRSJL15 1891-1892
  byte   PRSAU15 1893-1894
  byte   PRSSE15 1895-1896
  byte   PRSOC15 1897-1898
  byte   PRSNO15 1899-1900
  byte   PRSDE15 1901-1902
  byte   POUJA15 1903-1904
  byte   POUFE15 1905-1906
  byte   POUMA15 1907-1908
  byte   POUAP15 1909-1910
  byte   POUMY15 1911-1912
  byte   POUJU15 1913-1914
  byte   POUJL15 1915-1916
  byte   POUAU15 1917-1918
  byte   POUSE15 1919-1920
  byte   POUOC15 1921-1922
  byte   POUNO15 1923-1924
  byte   POUDE15 1925-1926
  byte   PRXJA15 1927-1928
  byte   PRXFE15 1929-1930
  byte   PRXMA15 1931-1932
  byte   PRXAP15 1933-1934
  byte   PRXMY15 1935-1936
  byte   PRXJU15 1937-1938
  byte   PRXJL15 1939-1940
  byte   PRXAU15 1941-1942
  byte   PRXSE15 1943-1944
  byte   PRXOC15 1945-1946
  byte   PRXNO15 1947-1948
  byte   PRXDE15 1949-1950
  byte   PRIJA15 1951-1952
  byte   PRIFE15 1953-1954
  byte   PRIMA15 1955-1956
  byte   PRIAP15 1957-1958
  byte   PRIMY15 1959-1960
  byte   PRIJU15 1961-1962
  byte   PRIJL15 1963-1964
  byte   PRIAU15 1965-1966
  byte   PRISE15 1967-1968
  byte   PRIOC15 1969-1970
  byte   PRINO15 1971-1972
  byte   PRIDE15 1973-1974
  byte   HPEJA15 1975-1976
  byte   HPEFE15 1977-1978
  byte   HPEMA15 1979-1980
  byte   HPEAP15 1981-1982
  byte   HPEMY15 1983-1984
  byte   HPEJU15 1985-1986
  byte   HPEJL15 1987-1988
  byte   HPEAU15 1989-1990
  byte   HPESE15 1991-1992
  byte   HPEOC15 1993-1994
  byte   HPENO15 1995-1996
  byte   HPEDE15 1997-1998
  byte   HPDJA15 1999-2000
  byte   HPDFE15 2001-2002
  byte   HPDMA15 2003-2004
  byte   HPDAP15 2005-2006
  byte   HPDMY15 2007-2008
  byte   HPDJU15 2009-2010
  byte   HPDJL15 2011-2012
  byte   HPDAU15 2013-2014
  byte   HPDSE15 2015-2016
  byte   HPDOC15 2017-2018
  byte   HPDNO15 2019-2020
  byte   HPDDE15 2021-2022
  byte   HPNJA15 2023-2024
  byte   HPNFE15 2025-2026
  byte   HPNMA15 2027-2028
  byte   HPNAP15 2029-2030
  byte   HPNMY15 2031-2032
  byte   HPNJU15 2033-2034
  byte   HPNJL15 2035-2036
  byte   HPNAU15 2037-2038
  byte   HPNSE15 2039-2040
  byte   HPNOC15 2041-2042
  byte   HPNNO15 2043-2044
  byte   HPNDE15 2045-2046
  byte   HPOJA15 2047-2048
  byte   HPOFE15 2049-2050
  byte   HPOMA15 2051-2052
  byte   HPOAP15 2053-2054
  byte   HPOMY15 2055-2056
  byte   HPOJU15 2057-2058
  byte   HPOJL15 2059-2060
  byte   HPOAU15 2061-2062
  byte   HPOSE15 2063-2064
  byte   HPOOC15 2065-2066
  byte   HPONO15 2067-2068
  byte   HPODE15 2069-2070
  byte   HPSJA15 2071-2072
  byte   HPSFE15 2073-2074
  byte   HPSMA15 2075-2076
  byte   HPSAP15 2077-2078
  byte   HPSMY15 2079-2080
  byte   HPSJU15 2081-2082
  byte   HPSJL15 2083-2084
  byte   HPSAU15 2085-2086
  byte   HPSSE15 2087-2088
  byte   HPSOC15 2089-2090
  byte   HPSNO15 2091-2092
  byte   HPSDE15 2093-2094
  byte   HPXJA15 2095-2096
  byte   HPXFE15 2097-2098
  byte   HPXMA15 2099-2100
  byte   HPXAP15 2101-2102
  byte   HPXMY15 2103-2104
  byte   HPXJU15 2105-2106
  byte   HPXJL15 2107-2108
  byte   HPXAU15 2109-2110
  byte   HPXSE15 2111-2112
  byte   HPXOC15 2113-2114
  byte   HPXNO15 2115-2116
  byte   HPXDE15 2117-2118
  byte   HPRJA15 2119-2120
  byte   HPRFE15 2121-2122
  byte   HPRMA15 2123-2124
  byte   HPRAP15 2125-2126
  byte   HPRMY15 2127-2128
  byte   HPRJU15 2129-2130
  byte   HPRJL15 2131-2132
  byte   HPRAU15 2133-2134
  byte   HPRSE15 2135-2136
  byte   HPROC15 2137-2138
  byte   HPRNO15 2139-2140
  byte   HPRDE15 2141-2142
  byte   INSJA15X 2143-2144
  byte   INSFE15X 2145-2146
  byte   INSMA15X 2147-2148
  byte   INSAP15X 2149-2150
  byte   INSMY15X 2151-2152
  byte   INSJU15X 2153-2154
  byte   INSJL15X 2155-2156
  byte   INSAU15X 2157-2158
  byte   INSSE15X 2159-2160
  byte   INSOC15X 2161-2162
  byte   INSNO15X 2163-2164
  byte   INSDE15X 2165-2166
  byte   PRVEV15 2167-2167
  byte   TRIEV15 2168-2168
  byte   MCREV15 2169-2169
  byte   MCDEV15 2170-2170
  byte   OPAEV15 2171-2171
  byte   OPBEV15 2172-2172
  byte   UNINS15 2173-2173
  byte   INSCOV15 2174-2174
  byte   INSURC15 2175-2175
  byte   TRIST31X 2176-2177
  byte   TRIST42X 2178-2179
  byte   TRIST15X 2180-2181
  byte   TRIPR31X 2182-2183
  byte   TRIPR42X 2184-2185
  byte   TRIPR15X 2186-2187
  byte   TRIEX31X 2188-2189
  byte   TRIEX42X 2190-2191
  byte   TRIEX15X 2192-2193
  byte   TRILI31X 2194-2195
  byte   TRILI42X 2196-2197
  byte   TRILI15X 2198-2199
  byte   TRICH31X 2200-2201
  byte   TRICH42X 2202-2203
  byte   TRICH15X 2204-2205
  byte   MCRPD31 2206-2207
  byte   MCRPD42 2208-2209
  byte   MCRPD15 2210-2211
  byte   MCRPD31X 2212-2213
  byte   MCRPD42X 2214-2215
  byte   MCRPD15X 2216-2217
  byte   MCRPB31 2218-2219
  byte   MCRPB42 2220-2221
  byte   MCRPB15 2222-2223
  byte   MCRPHO31 2224-2225
  byte   MCRPHO42 2226-2227
  byte   MCRPHO15 2228-2229
  byte   MCDHMO31 2230-2231
  byte   MCDHMO42 2232-2233
  byte   MCDHMO15 2234-2235
  byte   MCDMC31 2236-2237
  byte   MCDMC42 2238-2239
  byte   MCDMC15 2240-2241
  byte   PRVHMO31 2242-2243
  byte   PRVHMO42 2244-2245
  byte   PRVHMO15 2246-2247
  byte   FSAGT31 2248-2249
  byte   HASFSA31 2250-2251
  double FSAAMT31 2252-2259
  byte   PROBPY42 2260-2261
  byte   CRFMPY42 2262-2263
  byte   PYUNBL42 2264-2265
  byte   PREVCOVR 2266-2267
  byte   COVRMM 2268-2269
  int    COVRYY 2270-2273
  byte   WASESTB 2274-2275
  byte   WASMCARE 2276-2277
  byte   WASMCAID 2278-2279
  byte   WASCHAMP 2280-2281
  byte   WASVA 2282-2283
  byte   WASPRIV 2284-2285
  byte   WASOTGOV 2286-2287
  byte   WASAFDC 2288-2289
  byte   WASSSI 2290-2291
  byte   WASSTAT1 2292-2293
  byte   WASSTAT2 2294-2295
  byte   WASSTAT3 2296-2297
  byte   WASSTAT4 2298-2299
  byte   WASOTHER 2300-2301
  byte   NOINSBEF 2302-2303
  byte   NOINSTM 2304-2305
  byte   NOINUNIT 2306-2307
  byte   MORECOVR 2308-2309
  byte   INSENDMM 2310-2311
  int    INSENDYY 2312-2315
  byte   TRICR31X 2316-2317
  byte   TRICR42X 2318-2319
  byte   TRICR53X 2320-2321
  byte   TRICR15X 2322-2323
  byte   TRIAT31X 2324-2325
  byte   TRIAT42X 2326-2327
  byte   TRIAT53X 2328-2329
  byte   TRIAT15X 2330-2331
  byte   MCAID31 2332-2333
  byte   MCAID42 2334-2335
  byte   MCAID53 2336-2337
  byte   MCAID15 2338-2339
  byte   MCAID31X 2340-2341
  byte   MCAID42X 2342-2343
  byte   MCAID53X 2344-2345
  byte   MCAID15X 2346-2347
  byte   MCARE31 2348-2349
  byte   MCARE42 2350-2351
  byte   MCARE53 2352-2353
  byte   MCARE15 2354-2355
  byte   MCARE31X 2356-2357
  byte   MCARE42X 2358-2359
  byte   MCARE53X 2360-2361
  byte   MCARE15X 2362-2363
  byte   MCDAT31X 2364-2365
  byte   MCDAT42X 2366-2367
  byte   MCDAT53X 2368-2369
  byte   MCDAT15X 2370-2371
  byte   OTPAAT31 2372-2373
  byte   OTPAAT42 2374-2375
  byte   OTPAAT53 2376-2377
  byte   OTPAAT15 2378-2379
  byte   OTPBAT31 2380-2381
  byte   OTPBAT42 2382-2383
  byte   OTPBAT53 2384-2385
  byte   OTPBAT15 2386-2387
  byte   OTPUBA31 2388-2389
  byte   OTPUBA42 2390-2391
  byte   OTPUBA53 2392-2393
  byte   OTPUBA15 2394-2395
  byte   OTPUBB31 2396-2397
  byte   OTPUBB42 2398-2399
  byte   OTPUBB53 2400-2401
  byte   OTPUBB15 2402-2403
  byte   PRIDK31 2404-2405
  byte   PRIDK42 2406-2407
  byte   PRIDK53 2408-2409
  byte   PRIDK15 2410-2411
  byte   PRIEU31 2412-2413
  byte   PRIEU42 2414-2415
  byte   PRIEU53 2416-2417
  byte   PRIEU15 2418-2419
  byte   PRING31 2420-2421
  byte   PRING42 2422-2423
  byte   PRING53 2424-2425
  byte   PRING15 2426-2427
  byte   PRIOG31 2428-2429
  byte   PRIOG42 2430-2431
  byte   PRIOG53 2432-2433
  byte   PRIOG15 2434-2435
  byte   PRIS31 2436-2437
  byte   PRIS42 2438-2439
  byte   PRIS53 2440-2441
  byte   PRIS15 2442-2443
  byte   PROUT31 2444-2445
  byte   PROUT42 2446-2447
  byte   PROUT53 2448-2449
  byte   PROUT15 2450-2451
  byte   PRSTX31 2452-2453
  byte   PRSTX42 2454-2455
  byte   PRSTX53 2456-2457
  byte   PRSTX15 2458-2459
  byte   PRIV31 2460-2461
  byte   PRIV42 2462-2463
  byte   PRIV53 2464-2465
  byte   PRIV15 2466-2467
  byte   PRIVAT31 2468-2469
  byte   PRIVAT42 2470-2471
  byte   PRIVAT53 2472-2473
  byte   PRIVAT15 2474-2475
  byte   PUB31X 2476-2477
  byte   PUB42X 2478-2479
  byte   PUB53X 2480-2481
  byte   PUB15X 2482-2483
  byte   PUBAT31X 2484-2485
  byte   PUBAT42X 2486-2487
  byte   PUBAT53X 2488-2489
  byte   PUBAT15X 2490-2491
  byte   INS31X 2492-2493
  byte   INS42X 2494-2495
  byte   INS53X 2496-2497
  byte   INS15X 2498-2499
  byte   INSAT31X 2500-2501
  byte   INSAT42X 2502-2503
  byte   INSAT53X 2504-2505
  byte   INSAT15X 2506-2507
  byte   STAPR31 2508-2509
  byte   STAPR42 2510-2511
  byte   STAPR53 2512-2513
  byte   STAPR15 2514-2515
  byte   STPRAT31 2516-2517
  byte   STPRAT42 2518-2519
  byte   STPRAT53 2520-2521
  byte   STPRAT15 2522-2523
  byte   DENTIN31 2524-2525
  byte   DENTIN42 2526-2527
  byte   DENTIN53 2528-2529
  byte   DNTINS31 2530-2531
  byte   DNTINS15 2532-2533
  byte   PMEDIN31 2534-2535
  byte   PMEDIN42 2536-2537
  byte   PMEDIN53 2538-2539
  byte   PMDINS31 2540-2541
  byte   PMDINS15 2542-2543
  byte   PMEDUP31 2544-2545
  byte   PMEDUP42 2546-2547
  byte   PMEDUP53 2548-2549
  byte   PMEDPY31 2550-2551
  byte   PMEDPY42 2552-2553
  byte   PMEDPY53 2554-2555
  long   TOTTCH15 2556-2562
  long   TOTEXP15 2563-2568
  long   TOTSLF15 2569-2573
  long   TOTMCR15 2574-2579
  long   TOTMCD15 2580-2585
  long   TOTPRV15 2586-2591
  long   TOTVA15 2592-2597
  long   TOTTRI15 2598-2602
  long   TOTOFD15 2603-2607
  long   TOTSTL15 2608-2613
  long   TOTWCP15 2614-2619
  long   TOTOPR15 2620-2625
  long   TOTOPU15 2626-2630
  long   TOTOSR15 2631-2636
  long   TOTPTR15 2637-2642
  long   TOTOTH15 2643-2648
  int    OBTOTV15 2649-2651
  long   OBVTCH15 2652-2658
  long   OBVEXP15 2659-2664
  long   OBVSLF15 2665-2669
  long   OBVMCR15 2670-2675
  long   OBVMCD15 2676-2681
  long   OBVPRV15 2682-2687
  long   OBVVA15 2688-2692
  long   OBVTRI15 2693-2697
  long   OBVOFD15 2698-2702
  long   OBVSTL15 2703-2708
  long   OBVWCP15 2709-2713
  long   OBVOPR15 2714-2718
  long   OBVOPU15 2719-2723
  long   OBVOSR15 2724-2728
  long   OBVPTR15 2729-2734
  long   OBVOTH15 2735-2740
  int    OBDRV15 2741-2743
  long   OBDTCH15 2744-2750
  long   OBDEXP15 2751-2756
  long   OBDSLF15 2757-2761
  long   OBDMCR15 2762-2767
  long   OBDMCD15 2768-2773
  long   OBDPRV15 2774-2779
  long   OBDVA15 2780-2784
  int    OBDTRI15 2785-2788
  int    OBDOFD15 2789-2792
  long   OBDSTL15 2793-2798
  long   OBDWCP15 2799-2803
  long   OBDOPR15 2804-2808
  int    OBDOPU15 2809-2812
  long   OBDOSR15 2813-2817
  long   OBDPTR15 2818-2823
  long   OBDOTH15 2824-2829
  int    OBOTHV15 2830-2832
  long   OBOTCH15 2833-2838
  long   OBOEXP15 2839-2843
  long   OBOSLF15 2844-2848
  long   OBOMCR15 2849-2853
  long   OBOMCD15 2854-2858
  long   OBOPRV15 2859-2863
  long   OBOVA15 2864-2868
  long   OBOTRI15 2869-2873
  long   OBOOFD15 2874-2878
  long   OBOSTL15 2879-2883
  long   OBOWCP15 2884-2888
  long   OBOOPR15 2889-2893
  int    OBOOPU15 2894-2897
  long   OBOOSR15 2898-2902
  long   OBOPTR15 2903-2907
  long   OBOOTH15 2908-2912
  int    OBCHIR15 2913-2915
  long   OBCTCH15 2916-2920
  long   OBCEXP15 2921-2925
  int    OBCSLF15 2926-2929
  int    OBCMCR15 2930-2933
  int    OBCMCD15 2934-2937
  long   OBCPRV15 2938-2942
  int    OBCVA15 2943-2946
  int    OBCTRI15 2947-2949
  byte   OBCOFD15 2950-2950
  int    OBCSTL15 2951-2953
  int    OBCWCP15 2954-2957
  int    OBCOPR15 2958-2961
  int    OBCOPU15 2962-2964
  long   OBCOSR15 2965-2969
  long   OBCPTR15 2970-2974
  long   OBCOTH15 2975-2979
  int    OBNURS15 2980-2982
  long   OBNTCH15 2983-2988
  long   OBNEXP15 2989-2993
  int    OBNSLF15 2994-2997
  long   OBNMCR15 2998-3002
  long   OBNMCD15 3003-3007
  long   OBNPRV15 3008-3012
  int    OBNVA15 3013-3016
  int    OBNTRI15 3017-3020
  long   OBNOFD15 3021-3025
  long   OBNSTL15 3026-3030
  int    OBNWCP15 3031-3034
  int    OBNOPR15 3035-3038
  int    OBNOPU15 3039-3042
  int    OBNOSR15 3043-3046
  long   OBNPTR15 3047-3051
  long   OBNOTH15 3052-3056
  byte   OBOPTO15 3057-3058
  long   OBETCH15 3059-3063
  int    OBEEXP15 3064-3067
  int    OBESLF15 3068-3071
  int    OBEMCR15 3072-3074
  int    OBEMCD15 3075-3078
  int    OBEPRV15 3079-3082
  int    OBEVA15 3083-3086
  int    OBETRI15 3087-3089
  int    OBEOFD15 3090-3092
  byte   OBESTL15 3093-3094
  byte   OBEWCP15 3095-3095
  int    OBEOPR15 3096-3098
  int    OBEOPU15 3099-3101
  int    OBEOSR15 3102-3104
  int    OBEPTR15 3105-3108
  int    OBEOTH15 3109-3111
  byte   OBASST15 3112-3113
  long   OBATCH15 3114-3119
  long   OBAEXP15 3120-3124
  int    OBASLF15 3125-3128
  int    OBAMCR15 3129-3132
  int    OBAMCD15 3133-3136
  long   OBAPRV15 3137-3141
  int    OBAVA15 3142-3145
  int    OBATRI15 3146-3149
  int    OBAOFD15 3150-3152
  int    OBASTL15 3153-3155
  int    OBAWCP15 3156-3159
  int    OBAOPR15 3160-3163
  int    OBAOPU15 3164-3166
  int    OBAOSR15 3167-3169
  long   OBAPTR15 3170-3174
  int    OBAOTH15 3175-3178
  int    OBTHER15 3179-3181
  long   OBTTCH15 3182-3186
  long   OBTEXP15 3187-3191
  int    OBTSLF15 3192-3195
  long   OBTMCR15 3196-3200
  long   OBTMCD15 3201-3205
  long   OBTPRV15 3206-3210
  long   OBTVA15 3211-3215
  int    OBTTRI15 3216-3219
  int    OBTOFD15 3220-3223
  int    OBTSTL15 3224-3226
  long   OBTWCP15 3227-3231
  int    OBTOPR15 3232-3235
  int    OBTOPU15 3236-3238
  long   OBTOSR15 3239-3243
  long   OBTPTR15 3244-3248
  long   OBTOTH15 3249-3253
  int    OPTOTV15 3254-3256
  long   OPTTCH15 3257-3262
  long   OPTEXP15 3263-3268
  long   OPTSLF15 3269-3273
  long   OPTMCR15 3274-3279
  long   OPTMCD15 3280-3284
  long   OPTPRV15 3285-3289
  long   OPTVA15 3290-3294
  long   OPTTRI15 3295-3299
  long   OPTOFD15 3300-3304
  long   OPTSTL15 3305-3309
  long   OPTWCP15 3310-3314
  long   OPTOPR15 3315-3319
  long   OPTOPU15 3320-3324
  long   OPTOSR15 3325-3329
  long   OPTPTR15 3330-3334
  long   OPTOTH15 3335-3339
  long   OPFTCH15 3340-3345
  long   OPFEXP15 3346-3351
  long   OPFSLF15 3352-3356
  long   OPFMCR15 3357-3362
  long   OPFMCD15 3363-3367
  long   OPFPRV15 3368-3372
  long   OPFVA15 3373-3377
  long   OPFTRI15 3378-3382
  long   OPFOFD15 3383-3387
  long   OPFSTL15 3388-3392
  long   OPFWCP15 3393-3397
  long   OPFOPR15 3398-3402
  long   OPFOPU15 3403-3407
  long   OPFOSR15 3408-3412
  long   OPFPTR15 3413-3417
  long   OPFOTH15 3418-3422
  long   OPDEXP15 3423-3427
  long   OPDTCH15 3428-3432
  long   OPDSLF15 3433-3437
  long   OPDMCR15 3438-3442
  int    OPDMCD15 3443-3446
  long   OPDPRV15 3447-3451
  int    OPDVA15 3452-3455
  int    OPDTRI15 3456-3459
  byte   OPDOFD15 3460-3461
  int    OPDSTL15 3462-3465
  int    OPDWCP15 3466-3469
  int    OPDOPR15 3470-3473
  int    OPDOPU15 3474-3477
  int    OPDOSR15 3478-3481
  long   OPDPTR15 3482-3486
  int    OPDOTH15 3487-3490
  byte   OPDRV15 3491-3492
  long   OPVTCH15 3493-3498
  long   OPVEXP15 3499-3504
  long   OPVSLF15 3505-3509
  long   OPVMCR15 3510-3515
  long   OPVMCD15 3516-3520
  long   OPVPRV15 3521-3525
  long   OPVVA15 3526-3530
  long   OPVTRI15 3531-3535
  long   OPVOFD15 3536-3540
  long   OPVSTL15 3541-3545
  int    OPVWCP15 3546-3549
  int    OPVOPR15 3550-3553
  long   OPVOPU15 3554-3558
  int    OPVOSR15 3559-3562
  long   OPVPTR15 3563-3567
  long   OPVOTH15 3568-3572
  long   OPSEXP15 3573-3577
  long   OPSTCH15 3578-3582
  long   OPSSLF15 3583-3587
  long   OPSMCR15 3588-3592
  int    OPSMCD15 3593-3596
  long   OPSPRV15 3597-3601
  int    OPSVA15 3602-3604
  int    OPSTRI15 3605-3608
  byte   OPSOFD15 3609-3610
  int    OPSSTL15 3611-3614
  int    OPSWCP15 3615-3618
  int    OPSOPR15 3619-3622
  int    OPSOPU15 3623-3626
  int    OPSOSR15 3627-3630
  long   OPSPTR15 3631-3635
  int    OPSOTH15 3636-3639
  int    OPOTHV15 3640-3642
  long   OPOTCH15 3643-3648
  long   OPOEXP15 3649-3654
  int    OPOSLF15 3655-3658
  long   OPOMCR15 3659-3664
  long   OPOMCD15 3665-3669
  long   OPOPRV15 3670-3674
  long   OPOVA15 3675-3679
  long   OPOTRI15 3680-3684
  long   OPOOFD15 3685-3689
  int    OPOSTL15 3690-3693
  long   OPOWCP15 3694-3698
  long   OPOOPR15 3699-3703
  int    OPOOPU15 3704-3706
  int    OPOOSR15 3707-3710
  long   OPOPTR15 3711-3715
  long   OPOOTH15 3716-3720
  long   OPPEXP15 3721-3725
  long   OPPTCH15 3726-3730
  int    OPPSLF15 3731-3734
  int    OPPMCR15 3735-3738
  int    OPPMCD15 3739-3742
  long   OPPPRV15 3743-3747
  int    OPPVA15 3748-3750
  int    OPPTRI15 3751-3753
  byte   OPPOFD15 3754-3755
  int    OPPSTL15 3756-3758
  int    OPPWCP15 3759-3762
  int    OPPOPR15 3763-3765
  int    OPPOPU15 3766-3768
  int    OPPOSR15 3769-3772
  long   OPPPTR15 3773-3777
  int    OPPOTH15 3778-3781
  int    AMCHIR15 3782-3784
  long   AMCTCH15 3785-3789
  long   AMCEXP15 3790-3794
  int    AMCSLF15 3795-3798
  int    AMCMCR15 3799-3802
  int    AMCMCD15 3803-3806
  long   AMCPRV15 3807-3811
  int    AMCVA15 3812-3815
  int    AMCTRI15 3816-3818
  int    AMCOFD15 3819-3821
  int    AMCSTL15 3822-3824
  int    AMCWCP15 3825-3828
  int    AMCOPR15 3829-3832
  int    AMCOPU15 3833-3835
  long   AMCOSR15 3836-3840
  long   AMCPTR15 3841-3845
  long   AMCOTH15 3846-3850
  int    AMNURS15 3851-3853
  long   AMNTCH15 3854-3859
  long   AMNEXP15 3860-3864
  int    AMNSLF15 3865-3868
  long   AMNMCR15 3869-3873
  long   AMNMCD15 3874-3878
  long   AMNPRV15 3879-3883
  int    AMNVA15 3884-3887
  long   AMNTRI15 3888-3892
  long   AMNOFD15 3893-3897
  long   AMNSTL15 3898-3902
  int    AMNWCP15 3903-3906
  long   AMNOPR15 3907-3911
  int    AMNOPU15 3912-3915
  int    AMNOSR15 3916-3919
  long   AMNPTR15 3920-3924
  long   AMNOTH15 3925-3929
  byte   AMOPTO15 3930-3931
  long   AMETCH15 3932-3936
  int    AMEEXP15 3937-3940
  int    AMESLF15 3941-3944
  int    AMEMCR15 3945-3947
  int    AMEMCD15 3948-3951
  int    AMEPRV15 3952-3955
  int    AMEVA15 3956-3959
  int    AMETRI15 3960-3962
  int    AMEOFD15 3963-3965
  byte   AMESTL15 3966-3967
  byte   AMEWCP15 3968-3968
  int    AMEOPR15 3969-3971
  int    AMEOPU15 3972-3974
  int    AMEOSR15 3975-3977
  int    AMEPTR15 3978-3981
  int    AMEOTH15 3982-3984
  byte   AMASST15 3985-3986
  long   AMATCH15 3987-3992
  long   AMAEXP15 3993-3997
  int    AMASLF15 3998-4001
  int    AMAMCR15 4002-4005
  int    AMAMCD15 4006-4009
  long   AMAPRV15 4010-4014
  int    AMAVA15 4015-4018
  int    AMATRI15 4019-4022
  int    AMAOFD15 4023-4025
  int    AMASTL15 4026-4028
  int    AMAWCP15 4029-4032
  int    AMAOPR15 4033-4036
  int    AMAOPU15 4037-4039
  int    AMAOSR15 4040-4042
  long   AMAPTR15 4043-4047
  int    AMAOTH15 4048-4051
  int    AMTHER15 4052-4054
  long   AMTTCH15 4055-4060
  long   AMTEXP15 4061-4065
  int    AMTSLF15 4066-4069
  long   AMTMCR15 4070-4074
  long   AMTMCD15 4075-4079
  long   AMTPRV15 4080-4084
  long   AMTVA15 4085-4089
  int    AMTTRI15 4090-4093
  long   AMTOFD15 4094-4098
  int    AMTSTL15 4099-4101
  long   AMTWCP15 4102-4106
  long   AMTOPR15 4107-4111
  int    AMTOPU15 4112-4114
  long   AMTOSR15 4115-4119
  long   AMTPTR15 4120-4124
  long   AMTOTH15 4125-4129
  int    AMTOTC15 4130-4132
  byte   AMDRC15 4133-4133
  byte   ERTOT15 4134-4135
  long   ERTTCH15 4136-4141
  long   ERTEXP15 4142-4147
  long   ERTSLF15 4148-4152
  long   ERTMCR15 4153-4157
  long   ERTMCD15 4158-4162
  long   ERTPRV15 4163-4168
  long   ERTVA15 4169-4173
  int    ERTTRI15 4174-4177
  int    ERTOFD15 4178-4181
  int    ERTSTL15 4182-4185
  int    ERTWCP15 4186-4189
  long   ERTOPR15 4190-4194
  long   ERTOPU15 4195-4199
  long   ERTOSR15 4200-4204
  long   ERTPTR15 4205-4210
  long   ERTOTH15 4211-4215
  long   ERFTCH15 4216-4221
  long   ERFEXP15 4222-4227
  long   ERFSLF15 4228-4232
  long   ERFMCR15 4233-4237
  long   ERFMCD15 4238-4242
  long   ERFPRV15 4243-4248
  long   ERFVA15 4249-4253
  int    ERFTRI15 4254-4257
  int    ERFOFD15 4258-4261
  int    ERFSTL15 4262-4265
  int    ERFWCP15 4266-4269
  long   ERFOPR15 4270-4274
  long   ERFOPU15 4275-4279
  long   ERFOSR15 4280-4284
  long   ERFPTR15 4285-4290
  long   ERFOTH15 4291-4295
  int    ERDEXP15 4296-4299
  long   ERDTCH15 4300-4304
  int    ERDSLF15 4305-4308
  int    ERDMCR15 4309-4312
  int    ERDMCD15 4313-4316
  int    ERDPRV15 4317-4320
  int    ERDVA15 4321-4324
  int    ERDTRI15 4325-4327
  byte   ERDOFD15 4328-4328
  byte   ERDSTL15 4329-4330
  int    ERDWCP15 4331-4334
  int    ERDOPR15 4335-4338
  int    ERDOPU15 4339-4342
  int    ERDOSR15 4343-4346
  int    ERDPTR15 4347-4350
  int    ERDOTH15 4351-4354
  byte   IPZERO15 4355-4355
  long   ZIFTCH15 4356-4360
  long   ZIFEXP15 4361-4365
  int    ZIFSLF15 4366-4369
  long   ZIFMCR15 4370-4374
  long   ZIFMCD15 4375-4379
  long   ZIFPRV15 4380-4384
  long   ZIFVA15 4385-4389
  int    ZIFTRI15 4390-4393
  int    ZIFOFD15 4394-4397
  byte   ZIFSTL15 4398-4398
  byte   ZIFWCP15 4399-4399
  int    ZIFOPR15 4400-4403
  byte   ZIFOPU15 4404-4404
  int    ZIFOSR15 4405-4408
  long   ZIFPTR15 4409-4413
  int    ZIFOTH15 4414-4417
  int    ZIDEXP15 4418-4421
  long   ZIDTCH15 4422-4426
  int    ZIDSLF15 4427-4429
  int    ZIDMCR15 4430-4433
  int    ZIDMCD15 4434-4437
  int    ZIDPRV15 4438-4441
  byte   ZIDVA15 4442-4443
  byte   ZIDTRI15 4444-4444
  byte   ZIDOFD15 4445-4445
  byte   ZIDSTL15 4446-4446
  byte   ZIDWCP15 4447-4447
  int    ZIDOPR15 4448-4450
  byte   ZIDOPU15 4451-4451
  byte   ZIDOSR15 4452-4452
  int    ZIDPTR15 4453-4456
  int    ZIDOTH15 4457-4459
  byte   IPDIS15 4460-4461
  long   IPTEXP15 4462-4467
  long   IPTTCH15 4468-4474
  long   IPTSLF15 4475-4479
  long   IPTMCR15 4480-4485
  long   IPTMCD15 4486-4491
  long   IPTPRV15 4492-4497
  long   IPTVA15 4498-4503
  long   IPTTRI15 4504-4508
  long   IPTOFD15 4509-4513
  long   IPTSTL15 4514-4518
  long   IPTWCP15 4519-4523
  long   IPTOPR15 4524-4529
  long   IPTOPU15 4530-4534
  long   IPTOSR15 4535-4540
  long   IPTPTR15 4541-4546
  long   IPTOTH15 4547-4552
  long   IPFEXP15 4553-4558
  long   IPFTCH15 4559-4565
  long   IPFSLF15 4566-4570
  long   IPFMCR15 4571-4576
  long   IPFMCD15 4577-4582
  long   IPFPRV15 4583-4588
  long   IPFVA15 4589-4594
  long   IPFTRI15 4595-4599
  long   IPFOFD15 4600-4604
  long   IPFSTL15 4605-4609
  long   IPFWCP15 4610-4614
  long   IPFOPR15 4615-4620
  long   IPFOPU15 4621-4625
  long   IPFOSR15 4626-4631
  long   IPFPTR15 4632-4637
  long   IPFOTH15 4638-4643
  long   IPDEXP15 4644-4648
  long   IPDTCH15 4649-4654
  int    IPDSLF15 4655-4658
  long   IPDMCR15 4659-4663
  int    IPDMCD15 4664-4667
  long   IPDPRV15 4668-4672
  int    IPDVA15 4673-4676
  int    IPDTRI15 4677-4680
  int    IPDOFD15 4681-4684
  int    IPDSTL15 4685-4687
  int    IPDWCP15 4688-4691
  long   IPDOPR15 4692-4696
  int    IPDOPU15 4697-4700
  int    IPDOSR15 4701-4704
  long   IPDPTR15 4705-4709
  long   IPDOTH15 4710-4714
  int    IPNGTD15 4715-4717
  byte   DVTOT15 4718-4719
  long   DVTTCH15 4720-4724
  long   DVTEXP15 4725-4729
  long   DVTSLF15 4730-4734
  long   DVTMCR15 4735-4739
  long   DVTMCD15 4740-4744
  long   DVTPRV15 4745-4749
  long   DVTVA15 4750-4754
  int    DVTTRI15 4755-4758
  long   DVTOFD15 4759-4763
  int    DVTSTL15 4764-4767
  int    DVTWCP15 4768-4770
  int    DVTOPR15 4771-4774
  int    DVTOPU15 4775-4778
  int    DVTOSR15 4779-4782
  long   DVTPTR15 4783-4787
  long   DVTOTH15 4788-4792
  byte   DVGEN15 4793-4794
  long   DVGTCH15 4795-4799
  long   DVGEXP15 4800-4804
  long   DVGSLF15 4805-4809
  long   DVGMCR15 4810-4814
  long   DVGMCD15 4815-4819
  long   DVGPRV15 4820-4824
  long   DVGVA15 4825-4829
  int    DVGTRI15 4830-4833
  int    DVGOFD15 4834-4837
  int    DVGSTL15 4838-4841
  int    DVGWCP15 4842-4844
  int    DVGOPR15 4845-4848
  int    DVGOPU15 4849-4852
  int    DVGOSR15 4853-4856
  long   DVGPTR15 4857-4861
  int    DVGOTH15 4862-4865
  byte   DVORTH15 4866-4867
  long   DVOTCH15 4868-4872
  long   DVOEXP15 4873-4877
  long   DVOSLF15 4878-4882
  int    DVOMCR15 4883-4886
  int    DVOMCD15 4887-4890
  long   DVOPRV15 4891-4895
  int    DVOVA15 4896-4898
  int    DVOTRI15 4899-4902
  long   DVOOFD15 4903-4907
  int    DVOSTL15 4908-4910
  byte   DVOWCP15 4911-4911
  int    DVOOPR15 4912-4915
  byte   DVOOPU15 4916-4917
  int    DVOOSR15 4918-4921
  long   DVOPTR15 4922-4926
  long   DVOOTH15 4927-4931
  int    HHTOTD15 4932-4934
  int    HHAGD15 4935-4937
  long   HHATCH15 4938-4943
  long   HHAEXP15 4944-4949
  long   HHASLF15 4950-4954
  long   HHAMCR15 4955-4959
  long   HHAMCD15 4960-4965
  long   HHAPRV15 4966-4970
  int    HHAVA15 4971-4974
  long   HHATRI15 4975-4979
  byte   HHAOFD15 4980-4980
  long   HHASTL15 4981-4985
  long   HHAWCP15 4986-4991
  long   HHAOPR15 4992-4996
  long   HHAOPU15 4997-5001
  long   HHAOSR15 5002-5007
  long   HHAPTR15 5008-5012
  long   HHAOTH15 5013-5018
  int    HHINDD15 5019-5021
  long   HHNTCH15 5022-5026
  long   HHNEXP15 5027-5031
  long   HHNSLF15 5032-5036
  long   HHNMCD15 5037-5041
  int    HHNMCR15 5042-5045
  long   HHNPRV15 5046-5050
  byte   HHNVA15 5051-5052
  byte   HHNTRI15 5053-5054
  byte   HHNOFD15 5055-5055
  byte   HHNSTL15 5056-5056
  byte   HHNWCP15 5057-5057
  int    HHNOPR15 5058-5060
  byte   HHNOPU15 5061-5061
  int    HHNOSR15 5062-5064
  long   HHNPTR15 5065-5069
  int    HHNOTH15 5070-5072
  int    HHINFD15 5073-5075
  int    VISEXP15 5076-5079
  long   VISTCH15 5080-5084
  int    VISSLF15 5085-5088
  int    VISMCR15 5089-5092
  int    VISMCD15 5093-5096
  int    VISPRV15 5097-5100
  int    VISVA15 5101-5104
  int    VISTRI15 5105-5107
  int    VISOFD15 5108-5110
  int    VISSTL15 5111-5113
  int    VISWCP15 5114-5116
  int    VISOPR15 5117-5120
  int    VISOPU15 5121-5123
  int    VISOSR15 5124-5127
  int    VISPTR15 5128-5131
  int    VISOTH15 5132-5135
  long   OTHTCH15 5136-5140
  long   OTHEXP15 5141-5145
  long   OTHSLF15 5146-5150
  long   OTHMCR15 5151-5155
  long   OTHMCD15 5156-5160
  long   OTHPRV15 5161-5165
  int    OTHVA15 5166-5169
  int    OTHTRI15 5170-5173
  byte   OTHOFD15 5174-5175
  int    OTHSTL15 5176-5178
  int    OTHWCP15 5179-5181
  int    OTHOPR15 5182-5185
  int    OTHOPU15 5186-5188
  int    OTHOSR15 5189-5192
  long   OTHPTR15 5193-5197
  int    OTHOTH15 5198-5201
  int    RXTOT15 5202-5204
  long   RXEXP15 5205-5210
  long   RXSLF15 5211-5215
  long   RXMCR15 5216-5221
  long   RXMCD15 5222-5226
  long   RXPRV15 5227-5232
  long   RXVA15 5233-5237
  long   RXTRI15 5238-5242
  long   RXOFD15 5243-5247
  long   RXSTL15 5248-5252
  long   RXWCP15 5253-5257
  long   RXOPR15 5258-5262
  long   RXOPU15 5263-5267
  long   RXOSR15 5268-5272
  long   RXPTR15 5273-5278
  long   RXOTH15 5279-5283
  double PERWT15F 5284-5295
  double FAMWT15F 5296-5307
  double FAMWT15C 5308-5319
  double SAQWT15F 5320-5332
  double DIABW15F 5333-5344
  int    VARSTR 5345-5348
  byte   VARPSU 5349-5349
using H181.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID15 "FAMILY ID (STUDENT MERGED IN) - 12/31/15";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR15 "RU LETTER AS OF 12/31/15";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE15 "RU SIZE AS OF 12/31/15";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS15 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/15";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE15 "RU SIZE INCLUDING STUDENT AS OF 12/31/15";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION15 "CENSUS REGION AS OF 12/31/15";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS15 "REFERENCE PERSON AS OF 12/31/15";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP15 "1ST RESPONDENT INDICATOR AS OF 12/31/15";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY15 "WAS RESPONDENT A PROXY AS OF 12/31/15";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFM15 "2015 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY15 "2015 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP15 "INSCOPE - R5/3 START THROUGH 12/31/15";
label variable INSC1231 "INSCOPE STATUS ON 12/31/15";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2015";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND15 "ELIGIBILITY STATUS AS OF 12/31/15";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE15X "AGE AS OF 12/31/15(EDITED/IMPUTED)";
label variable AGELAST "PERSON S AGE LAST TIME ELIGIBLE";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEV1X "RACE (EDITED/IMPUTED)";
label variable RACEV2X "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPNCAT "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY15X "MARITAL STATUS-12/31/15 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID15 "SPOUSE ID - 12/31/15";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN15 "MARITAL STATUS W/SPOUSE PRESENT-12/31/15";
label variable EDUYRDG "YEAR OF EDUCATION OR HIGHEST DEGREE";
label variable EDUCYR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEG "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable EDRECODE "EDUCATION RECODE (EDITED)";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU15X "STUDENT STATUS IF AGES 17-23 - 12/31/15";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable HONRDC31 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC42 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC53 "HONORABLY DISCHARGED FROM MILITARY";
label variable REFRL31X "RELATION TO REF PERS- R3/1 (EDIT/IMP)";
label variable REFRL42X "RELATION TO REF PERS- R4/2 (EDIT/IMP)";
label variable REFRL53X "RELATION TO REF PERS- R5/3 (EDIT/IMP)";
label variable REFRL15X "RELATION TO REF PERS-12/31/15 (EDIT/IMP)";
label variable OTHLANG "IN FAMILY WITH SOMEONE SPKNG OTHER LANG";
label variable LANGSPK "LANGUAGE SPOKEN AT HOME OTHER THAN ENGL";
label variable HWELLSPE "HOW WELL PERSON SPEAKS ENGLISH";
label variable BORNUSA "PERSON BORN IN THE US";
label variable YRSINUS "YEARS PERSON LIVED IN THE US";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable HIBPDX "HIGH BLOOD PRESSURE DIAG (>17)";
label variable HIBPAGED "AGE OF DIAGNOSIS-HIGH BLOOD PRESSURE";
label variable BPMLDX "MULT DIAG HIGH BLOOD PRESS (>17)";
label variable CHDDX "CORONARY HRT DISEASE DIAG (>17)";
label variable CHDAGED "AGE OF DIAGNOSIS-CORONARY HEART DISEASE";
label variable ANGIDX "ANGINA DIAGNOSIS (>17)";
label variable ANGIAGED "AGE OF DIAGNOSIS-ANGINA";
label variable MIDX "HEART ATTACK (MI) DIAG (>17)";
label variable MIAGED "AGE OF DIAGNOSIS-HEART ATTACK(MI)";
label variable OHRTDX "OTHER HEART DISEASE DIAG (>17)";
label variable OHRTAGED "AGE OF DIAGNOSIS-OTHER HEART DISEASE";
label variable STRKDX "STROKE DIAGNOSIS (>17)";
label variable STRKAGED "AGE OF DIAGNOSIS-STROKE";
label variable EMPHDX "EMPHYSEMA DIAGNOSIS (>17)";
label variable EMPHAGED "AGE OF DIAGNOSIS-EMPHYSEMA";
label variable CHBRON31 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R3/1";
label variable CHBRON53 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R5/3";
label variable CHOLDX "HIGH CHOLESTEROL DIAGNOSIS (>17)";
label variable CHOLAGED "AGE OF DIAGNOSIS-HIGH CHOLESTEROL";
label variable CANCERDX "CANCER DIAGNOSIS (>17)";
label variable CABLADDR "CANCER DIAGNOSED - BLADDER (>17)";
label variable CABREAST "CANCER DIAGNOSED - BREAST (>17)";
label variable CACERVIX "CANCER DIAGNOSED - CERVIX (>17)";
label variable CACOLON "CANCER DIAGNOSED - COLON (>17)";
label variable CALUNG "CANCER DIAGNOSED - LUNG (>17)";
label variable CALYMPH "CANCER DIAGNOSED - LYMPHOMA (>17)";
label variable CAMELANO "CANCER DIAGNOSED - MELANOMA (>17)";
label variable CAOTHER "CANCER DIAGNOSED - OTHER (>17)";
label variable CAPROSTA "CANCER DIAGNOSED - PROSTATE (>17)";
label variable CASKINNM "CANCER DIAGNOSED - SKIN-NONMELANO (>17)";
label variable CASKINDK "CANCER DIAGNOSED-SKIN-UNKNOWN TYPE (>17)";
label variable CAUTERUS "CANCER DIAGNOSED - UTERUS (>17)";
label variable DIABDX "DIABETES DIAGNOSIS (>17)";
label variable DIABAGED "AGE OF DIAGNOSIS-DIABETES";
label variable JTPAIN31 "JOINT PAIN LAST 12 MONTHS (>17) - RD 3/1";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX "ARTHRITIS DIAGNOSIS (>17)";
label variable ARTHTYPE "TYPE OF ARTHRITIS DIAGNOSED (>17)";
label variable ARTHAGED "AGE OF DIAGNOSIS-ARTHRITIS";
label variable ASTHDX "ASTHMA DIAGNOSIS";
label variable ASTHAGED "AGE OF DIAGNOSIS-ASTHMA";
label variable ASSTIL31 "DOES PERSON STILL HAVE ASTHMA-RD3/1";
label variable ASSTIL53 "DOES PERSON STILL HAVE ASTHMA - RD 5/3";
label variable ASATAK31 "ASTHMA ATTACK LAST 12 MOS - RD3/1";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASTHEP31 "WHEN WAS LAST EPISODE OF ASTHMA - RD 3/1";
label variable ASTHEP53 "WHEN WAS LAST EPISODE OF ASTHMA - RD 5/3";
label variable ASACUT53 "USED ACUTE PRES INHALER LAST 3 MOS-RD5/3";
label variable ASMRCN53 "USED>3ACUTE CN PRES INH LAST 3 MOS-RD5/3";
label variable ASPREV53 "EVER USED PREV DAILY ASTHMA MEDS -RD 5/3";
label variable ASDALY53 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 5/3";
label variable ASPKFL53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable ASEVFL53 "EVER USED PEAK FLOW METER - RD 5/3";
label variable ASWNFL53 "WHEN LAST USED PEAK FLOW METER - RD 5/3";
label variable ADHDADDX "ADHDADD DIAGNOSIS (5-17)";
label variable ADHDAGED "AGE OF DIAGNOSIS-ADHD/ADD";
label variable PREGNT31 "PREGNANT DURING REF PERIOD - RD 3/1";
label variable PREGNT42 "PREGNANT DURING REF PERIOD - RD 4/2";
label variable PREGNT53 "PREGNANT DURING REF PERIOD - RD 5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable DFHEAR42 "SERIOUS DIFFICULTY HEARING-RD 4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable DFSEE42 "SERIOUS DIFFICULTY SEE W/GLASSES-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable DFCOG42 "SERIOUS COGNITIVE DIFFICULTIES-RD 4/2";
label variable DFWLKC42 "SERIOUS DIFCULTY WLK/CLIMB STAIRS-RD 4/2";
label variable DFDRSB42 "DIFFICULTY DRESSING/BATHING-RD 4/2";
label variable DFERND42 "DIFFICULTY DOING ERRANDS ALONE-RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable ANYLMT15 "ANY LIMITATION IN P19R3,4,5/P20R1,2,3";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHENEC42 "CAHPS:12MOS:EASY GET NEC CARE (0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHEYRE42 "CAHPS:12MOS:ESY W/RFR TO SPEC(0-17)-R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU VACINATION (>17)-RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable BSTST53 "MST RCNT BLD STOOL TST HME KIT(>39)-R5/3";
label variable BSTSRE53 "RSN HAVE BLD STOOL TST (>39)-R5/3";
label variable CLNTST53 "MOST RECENT COLONOSCOPY (>39) - R5/3";
label variable CLNTRE53 "RSN HAVE COLONOSCOPY (>39)-R5/3";
label variable SGMTST53 "MOST RECENT SIGMOIDOSCOPY (>39) - R5/3";
label variable SGMTRE53 "RSN HAVE SIGMOIDOSCOPY (>39)-R5/3";
label variable PHYEXE53 "MOD/VIG PHYS EXEC 5X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRXY42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADEGMC42 "SAQ 12MOS: EASY GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADINST42 "SAQ 12 MOS: DR GAVE SPCIFC INSTRCTNS";
label variable ADEZUN42 "SAQ 12 MOS: DR GIVEN INSTR. EZ UNDRSTD";
label variable ADTLHW42 "SAQ 12 MOS: DR ASKED R DESC HOW FOLLOW";
label variable ADFFRM42 "SAQ 12 MOS: HAD TO FILL OUT/SIGN FORMS";
label variable ADFHLP42 "SAQ 12 MOS: OFFRD HELP FILLING OUT FORMS";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADESSP42 "SAQ 12MOS: HOW ESY TO SEE SPECIALIST";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12V2";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12V2";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12V2";
label variable ADPALS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS SF-12V2";
label variable ADPWLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS SF-12V2";
label variable ADMALS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS SF-12V2";
label variable ADMWLM42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS SF-12V2";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK SF-12V2";
label variable ADCAPE42 "SAQ 4WKS: FELT CALM/PEACEFUL SF-12V2";
label variable ADNRGY42 "SAQ 4WKS: HAD A LOT OF ENERGY SF-12V2";
label variable ADDOWN42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR SF-12V2";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV SF-12V2";
label variable PCS42 "SAQ:PHY COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable MCS42 "SAQ:MNT COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable SFFLAG42 "SAQ: PCS/MCS IMPUTATION FLAG SF-12V2";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVRYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C IN 2015";
label variable DSFT1653 "DCS: HAD FEET CHECKED DURING 2016";
label variable DSFT1553 "DCS: HAD FEET CHECKED DURING 2015";
label variable DSFT1453 "DCS: HAD FEET CHECKED DURING 2014";
label variable DSFB1453 "DCS: HAD FEET CHECKED BEFORE 2014";
label variable DSFTNV53 "DCS: NEVER HAD FEET CHECKED";
label variable DSEY1653 "DCS: DILATED EYE EXAM IN 2016";
label variable DSEY1553 "DCS: DILATED EYE EXAM IN 2015";
label variable DSEY1453 "DCS: DILATED EYE EXAM IN 2014";
label variable DSEB1453 "DCS: DILATED EYE EXAM BEFORE 2014";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSCH1653 "DCS: BLOOD CHOLESTEROL CHECKED IN 2016";
label variable DSCH1553 "DCS: BLOOD CHOLESTEROL CHECKED IN 2015";
label variable DSCH1453 "DCS: BLOOD CHOLESTEROL CHECKED IN 2014";
label variable DSCB1453 "DCS: BLOOD CHOLESTEROL CHECKED BEF 2014";
label variable DSCHNV53 "DCS: NEVER HAD BLOOD CHOLESTEROL CHECKED";
label variable DSFL1653 "DCS: GOT FLU VACCINATION IN 2016";
label variable DSFL1553 "DCS: GOT FLU VACCINATION IN 2015";
label variable DSFL1453 "DCS: GOT FLU VACCINATION IN 2014";
label variable DSVB1453 "DCS: GOT FLU VACCINATION BEFORE 2014";
label variable DSFLNV53 "DCS: NEVER GOT FLU VACCINATION";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSCPCP53 "DCS: LEARNED CARE FROM PRIMARY CARE PROV";
label variable DSCNPC53 "DCS: LEARNED CARE FROM OTHER PROVIDER";
label variable DSCPHN53 "DCS: LEARN CARE FROM PHONE CALL W/PROV";
label variable DSCINT53 "DCS: LEARNED CARE FROM READING INTERNET";
label variable DSCGRP53 "DCS: LEARNED CARE BY TAKING GROUP CLASS";
label variable DSCONF53 "DCS: CONFIDENT TAKING CARE OF DIABETES";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable DDNWRK15 "# DAYS MISSED WORK DUE TO ILL/INJ 2015";
label variable DDNSCL15 "# DAYS MISSD SCHOOL DUE TO ILL/INJ 2015";
label variable OTHDYS15 "MISS ANY WORK DAY TO CARE FOR OTH 2015";
label variable OTHNDD15 "# DAY MISSED WORK TO CARE FOR OTH 2015";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable NOHINS42 "AC08 OTH REAS NO USC:NO HLTH INSRNC-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable HEALTH42 "AC08 OTH REAS NO USC: HLTH RELATED-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable ONJOB42 "AC08 OTH REAS NO USC: DR AT WORK-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable CLINIC42 "AC08 OTH REAS NO USC: HOSP/ER/CLNIC-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable PRVSPK42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/15";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable EMPST31H "EMPLOYMENT STATUS RD 3/1 (IMP)";
label variable EMPST42H "EMPLOYMENT STATUS RD 4/2 (IMP)";
label variable EMPST53H "EMPLOYMENT STATUS RD 5/3 (IMP)";
label variable SLFCM31H "SELF-EMPLOYED AT RD 3/1 CMJ (IMP)";
label variable SLFCM42H "SELF-EMPLOYED AT RD 4/2 CMJ (IMP)";
label variable SLFCM53H "SELF-EMPLOYED AT RD 5/3 CMJ (IMP)";
label variable NMEMP31H "NUMBER OF EMPLOYEES AT RD 3/1 CMJ (IMP)";
label variable NMEMP42H "NUMBER OF EMPLOYEES AT RD 4/2 CMJ (IMP)";
label variable NMEMP53H "NUMBER OF EMPLOYEES AT RD 5/3 CMJ (IMP)";
label variable MORE31H "RD 3/1 CMJ FIRM MORE THAN 1 LOCAT (IMP)";
label variable MORE42H "RD 4/2 CMJ FIRM MORE THAN 1 LOCAT (IMP)";
label variable MORE53H "RD 5/3 CMJ FIRM MORE THAN 1 LOCAT (IMP)";
label variable INDCT31H "INDUSTRY GROUP RD 3/1 CMJ (IMP)";
label variable INDCT42H "INDUSTRY GROUP RD 4/2 CMJ (IMP)";
label variable INDCT53H "INDUSTRY GROUP RD 5/3 CMJ (IMP)";
label variable OCCCT31H "OCCUPATION GROUP RD 3/1 CMJ (IMP)";
label variable OCCCT42H "OCCUPATION GROUP RD 4/2 CMJ (IMP)";
label variable OCCCT53H "OCCUPATION GROUP RD 5/3 CMJ (IMP)";
label variable HOUR31H "HOURS PER WEEK AT RD 3/1 CMJ (IMP)";
label variable HOUR42H "HOURS PER WEEK AT RD 4/2 CMJ (IMP)";
label variable HOUR53H "HOURS PER WEEK AT RD 5/3 CMJ (IMP)";
label variable JBORG31H "PRV, ST-LC GOV, FED GOV RD 3/1 CMJ (IMP)";
label variable JBORG42H "PRV, ST-LC GOV, FED GOV RD 4/2 CMJ (IMP)";
label variable JBORG53H "PRV, ST-LC GOV, FED GOV RD 5/3 CMJ (IMP)";
label variable UNION31H "UNION STATUS AT RD 3/1 CMJ (IMP)";
label variable UNION42H "UNION STATUS AT RD 4/2 CMJ (IMP)";
label variable UNION53H "UNION STATUS AT RD 5/3 CMJ (IMP)";
label variable BSNTY31H "SOL PROP, PRTNR, CORP, RD 3/1 CMJ (IMP)";
label variable BSNTY42H "SOL PROP, PRTNR, CORP, RD 4/2 CMJ (IMP)";
label variable BSNTY53H "SOL PROP, PRTNR, CORP, RD 5/3 CMJ (IMP)";
label variable HRWG31H "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42H "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53H "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable CMJHLD31 "HLTH INSUR HELD FROM RD 3/1 CMJ (PRPL)";
label variable CMJHLD42 "HLTH INSUR HELD FROM RD 4/2 CMJ (PRPL)";
label variable CMJHLD53 "HLTH INSUR HELD FROM RD 5/3 CMJ (PRPL)";
label variable OFFER31H "HEALTH INSUR OFFERED BY RD 3/1 CMJ (IMP)";
label variable OFFER42H "HEALTH INSUR OFFERED BY RD 4/2 CMJ (IMP)";
label variable OFFER53H "HEALTH INSUR OFFERED BY RD 5/3 CMJ (IMP)";
label variable OFEMP31H "EMP OFFERS HEALTH INS RD 3/1 CMJ (IMP)";
label variable OFEMP42H "EMP OFFERS HEALTH INS RD 4/2 CMJ (IMP)";
label variable OFEMP53H "EMP OFFERS HEALTH INS RD 5/3 CMJ (IMP)";
label variable PYVAC31H "PAID VACATION AT RD 3/1 CMJ (IMP)";
label variable PYVAC42H "PAID VACATION AT RD 4/2 CMJ (IMP)";
label variable PYVAC53H "PAID VACATION AT RD 5/3 CMJ (IMP)";
label variable SCPAY31H "PAID SICK LEAVE AT RD 3/1 CMJ (IMP)";
label variable SCPAY42H "PAID SICK LEAVE AT RD 4/2 CMJ (IMP)";
label variable SCPAY53H "PAID SICK LEAVE AT RD 5/3 CMJ (IMP)";
label variable PAYDR31H "PAID LEAVE TO VISIT DR RD 3/1 CMJ (IMP)";
label variable PAYDR42H "PAID LEAVE TO VISIT DR RD 4/2 CMJ (IMP)";
label variable PAYDR53H "PAID LEAVE TO VISIT DR RD 5/3 CMJ (IMP)";
label variable RTPLN31H "PENSION PLAN AT RD 3/1 CMJ (IMP)";
label variable RTPLN42H "PENSION PLAN AT RD 4/2 CMJ (IMP)";
label variable RTPLN53H "PENSION PLAN AT RD 5/3 CMJ (IMP)";
label variable AFDC15 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR15 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL15 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT15 "PERSON S FILING STATUS";
label variable FILER15 "PRIMARY OR SECONDARY FILER";
label variable JTINRU15 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID15 "PID OF SECONDARY FILER";
label variable CLMDEP15 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT15 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU15 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD15 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM15 "TAX FORM PERSON WILL FILE";
label variable CLMHIP15 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT15 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST15 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN15 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODVL15 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP15X "PERSON S TOTAL INCOME";
label variable FAMINC15 "FAMILY S TOTAL INCOME";
label variable POVCAT15 "FAMILY INC AS % OF POVERTY LINE - CATEGO";
label variable POVLEV15 "FAMILY INC AS % OF POVERTY LINE - CONTIN";
label variable WAGEP15X "PERSON S WAGE INCOME";
label variable WAGIMP15 "WAGE IMPUTATION FLAG";
label variable BUSNP15X "PERSON S BUSINESS INCOME";
label variable BUSIMP15 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP15X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP15 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP15X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP15 "WORKERS  COMP IMPUTATION FLAG";
label variable INTRP15X "PERSON S INTEREST INCOME";
label variable INTIMP15 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP15X "PERSON S DIVIDEND INCOME";
label variable DIVIMP15 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP15X "PERSON S SALES INCOME";
label variable SALIMP15 "SALES INCOME IMPUTATION FLAG";
label variable PENSP15X "PERSON S PENSION INCOME";
label variable PENIMP15 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP15X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP15 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP15X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP15 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP15X "PERSON S VETERAN S INCOME";
label variable VETIMP15 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP15X "PERSON S IRA INCOME";
label variable IRAIMP15 "IRA INCOME IMPUTATION FLAG";
label variable ALIMP15X "PERSON S ALIMONY INCOME";
label variable ALIIMP15 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP15X "PERSON S CHILD SUPPORT";
label variable CHLIMP15 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP15X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP15 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP15X "PERSON S SSI";
label variable SSIIMP15 "SSI IMPUTATION FLAG";
label variable PUBP15X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP15 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP15X "PERSON S OTHER INCOME";
label variable OTHIMP15 "OTHER INCOME IMPUTATION FLAG";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable TRIJA15X "COVERED BY TRICARE/CHAMPVA IN JAN15 (ED)";
label variable TRIFE15X "COVERED BY TRICARE/CHAMPVA IN FEB15 (ED)";
label variable TRIMA15X "COVERED BY TRICARE/CHAMPVA IN MAR15 (ED)";
label variable TRIAP15X "COVERED BY TRICARE/CHAMPVA IN APR15(ED)";
label variable TRIMY15X "COVERED BY TRICARE/CHAMPVA IN MAY15 (ED)";
label variable TRIJU15X "COVERED BY TRICARE/CHAMPVA IN JUN15 (ED)";
label variable TRIJL15X "COVERED BY TRICARE/CHAMPVA IN JUL15 (ED)";
label variable TRIAU15X "COVERED BY TRICARE/CHAMPVA IN AUG15 (ED)";
label variable TRISE15X "COVERED BY TRICARE/CHAMPVA IN SEP15 (ED)";
label variable TRIOC15X "COVERED BY TRICARE/CHAMPVA IN OCT15 (ED)";
label variable TRINO15X "COVERED BY TRICARE/CHAMPVA IN NOV15 (ED)";
label variable TRIDE15X "COVERED BY TRICARE/CHAMPVA IN DEC15 (ED)";
label variable MCRJA15 "COVERED BY MEDICARE IN JAN15";
label variable MCRFE15 "COVERED BY MEDICARE IN FEB15";
label variable MCRMA15 "COVERED BY MEDICARE IN MAR15";
label variable MCRAP15 "COVERED BY MEDICARE IN APR15";
label variable MCRMY15 "COVERED BY MEDICARE IN MAY15";
label variable MCRJU15 "COVERED BY MEDICARE IN JUN15";
label variable MCRJL15 "COVERED BY MEDICARE IN JUL15";
label variable MCRAU15 "COVERED BY MEDICARE IN AUG15";
label variable MCRSE15 "COVERED BY MEDICARE IN SEP15";
label variable MCROC15 "COVERED BY MEDICARE IN OCT15";
label variable MCRNO15 "COVERED BY MEDICARE IN NOV15";
label variable MCRDE15 "COVERED BY MEDICARE IN DEC15";
label variable MCRJA15X "COVERED BY MEDICARE IN JAN15 (ED)";
label variable MCRFE15X "COVERED BY MEDICARE IN FEB15 (ED)";
label variable MCRMA15X "COVERED BY MEDICARE IN MAR15 (ED)";
label variable MCRAP15X "COVERED BY MEDICARE IN APR15 (ED)";
label variable MCRMY15X "COVERED BY MEDICARE IN MAY15 (ED)";
label variable MCRJU15X "COVERED BY MEDICARE IN JUN15 (ED)";
label variable MCRJL15X "COVERED BY MEDICARE IN JUL15 (ED)";
label variable MCRAU15X "COVERED BY MEDICARE IN AUG15 (ED)";
label variable MCRSE15X "COVERED BY MEDICARE IN SEP15 (ED)";
label variable MCROC15X "COVERED BY MEDICARE IN OCT15 (ED)";
label variable MCRNO15X "COVERED BY MEDICARE IN NOV15 (ED)";
label variable MCRDE15X "COVERED BY MEDICARE IN DEC15 (ED)";
label variable MCDJA15 "COV BY MEDICAID OR SCHIP IN JAN15";
label variable MCDFE15 "COV BY MEDICAID OR SCHIP IN FEB15";
label variable MCDMA15 "COV BY MEDICAID OR SCHIP IN MAR15";
label variable MCDAP15 "COV BY MEDICAID OR SCHIP IN APR15";
label variable MCDMY15 "COV BY MEDICAID OR SCHIP IN MAY15";
label variable MCDJU15 "COV BY MEDICAID OR SCHIP IN JUN15";
label variable MCDJL15 "COV BY MEDICAID OR SCHIP IN JUL15";
label variable MCDAU15 "COV BY MEDICAID OR SCHIP IN AUG15";
label variable MCDSE15 "COV BY MEDICAID OR SCHIP IN SEP15";
label variable MCDOC15 "COV BY MEDICAID OR SCHIP IN OCT15";
label variable MCDNO15 "COV BY MEDICAID OR SCHIP IN NOV15";
label variable MCDDE15 "COV BY MEDICAID OR SCHIP IN DEC15";
label variable MCDJA15X "COV BY MEDICAID OR SCHIP IN JAN15 (ED)";
label variable MCDFE15X "COV BY MEDICAID OR SCHIP IN FEB15 (ED)";
label variable MCDMA15X "COV BY MEDICAID OR SCHIP IN MAR15 (ED)";
label variable MCDAP15X "COV BY MEDICAID OR SCHIP IN APR15 (ED)";
label variable MCDMY15X "COV BY MEDICAID OR SCHIP IN MAY15 (ED)";
label variable MCDJU15X "COV BY MEDICAID OR SCHIP IN JUN15 (ED)";
label variable MCDJL15X "COV BY MEDICAID OR SCHIP IN JUL15 (ED)";
label variable MCDAU15X "COV BY MEDICAID OR SCHIP IN AUG15 (ED)";
label variable MCDSE15X "COV BY MEDICAID OR SCHIP IN SEP15 (ED)";
label variable MCDOC15X "COV BY MEDICAID OR SCHIP IN OCT15 (ED)";
label variable MCDNO15X "COV BY MEDICAID OR SCHIP IN NOV15 (ED)";
label variable MCDDE15X "COV BY MEDICAID OR SCHIP IN DEC15 (ED)";
label variable OPAJA15 "COV BY OTHER PUBLIC A INS IN JAN15";
label variable OPAFE15 "COV BY OTHER PUBLIC A INS IN FEB15";
label variable OPAMA15 "COV BY OTHER PUBLIC A INS IN MAR15";
label variable OPAAP15 "COV BY OTHER PUBLIC A INS IN APR15";
label variable OPAMY15 "COV BY OTHER PUBLIC A INS IN MAY15";
label variable OPAJU15 "COV BY OTHER PUBLIC A INS IN JUN15";
label variable OPAJL15 "COV BY OTHER PUBLIC A INS IN JUL15";
label variable OPAAU15 "COV BY OTHER PUBLIC A INS IN AUG15";
label variable OPASE15 "COV BY OTHER PUBLIC A INS IN SEP15";
label variable OPAOC15 "COV BY OTHER PUBLIC A INS IN OCT15";
label variable OPANO15 "COV BY OTHER PUBLIC A INS IN NOV15";
label variable OPADE15 "COV BY OTHER PUBLIC A INS IN DEC15";
label variable OPBJA15 "COV BY OTHER PUBLIC B INS IN JAN15";
label variable OPBFE15 "COV BY OTHER PUBLIC B INS IN FEB15";
label variable OPBMA15 "COV BY OTHER PUBLIC B INS IN MAR15";
label variable OPBAP15 "COV BY OTHER PUBLIC B INS IN APR15";
label variable OPBMY15 "COV BY OTHER PUBLIC B INS IN MAY15";
label variable OPBJU15 "COV BY OTHER PUBLIC B INS IN JUN15";
label variable OPBJL15 "COV BY OTHER PUBLIC B INS IN JUL15";
label variable OPBAU15 "COV BY OTHER PUBLIC B INS IN AUG15";
label variable OPBSE15 "COV BY OTHER PUBLIC B INS IN SEP15";
label variable OPBOC15 "COV BY OTHER PUBLIC B INS IN OCT15";
label variable OPBNO15 "COV BY OTHER PUBLIC B INS IN NOV15";
label variable OPBDE15 "COV BY OTHER PUBLIC B INS IN DEC15";
label variable STAJA15 "COVERED BY OTHER STATE PROG IN JAN15";
label variable STAFE15 "COVERED BY OTHER STATE PROG IN FEB15";
label variable STAMA15 "COVERED BY OTHER STATE PROG IN MAR15";
label variable STAAP15 "COVERED BY OTHER STATE PROG IN APR15";
label variable STAMY15 "COVERED BY OTHER STATE PROG IN MAY15";
label variable STAJU15 "COVERED BY OTHER STATE PROG IN JUN15";
label variable STAJL15 "COVERED BY OTHER STATE PROG IN JUL15";
label variable STAAU15 "COVERED BY OTHER STATE PROG IN AUG15";
label variable STASE15 "COVERED BY OTHER STATE PROG IN SEP15";
label variable STAOC15 "COVERED BY OTHER STATE PROG IN OCT15";
label variable STANO15 "COVERED BY OTHER STATE PROG IN NOV15";
label variable STADE15 "COVERED BY OTHER STATE PROG IN DEC15";
label variable PUBJA15X "COVR BY ANY PUBLIC INS IN JAN15 (ED)";
label variable PUBFE15X "COVR BY ANY PUBLIC INS IN FEB15 (ED)";
label variable PUBMA15X "COVR BY ANY PUBLIC INS IN MAR15 (ED)";
label variable PUBAP15X "COVR BY ANY PUBLIC INS IN APR15 (ED)";
label variable PUBMY15X "COVR BY ANY PUBLIC INS IN MAY15 (ED)";
label variable PUBJU15X "COVR BY ANY PUBLIC INS IN JUN15 (ED)";
label variable PUBJL15X "COVR BY ANY PUBLIC INS IN JUL15 (ED)";
label variable PUBAU15X "COVR BY ANY PUBLIC INS IN AUG15 (ED)";
label variable PUBSE15X "COVR BY ANY PUBLIC INS IN SEP15 (ED)";
label variable PUBOC15X "COVR BY ANY PUBLIC INS IN OCT15 (ED)";
label variable PUBNO15X "COVR BY ANY PUBLIC INS IN NOV15 (ED)";
label variable PUBDE15X "COVR BY ANY PUBLIC INS IN DEC15 (ED)";
label variable PEGJA15 "COVERED BY EMPL UNION INS IN JAN15";
label variable PEGFE15 "COVERED BY EMPL UNION INS IN FEB15";
label variable PEGMA15 "COVERED BY EMPL UNION INS IN MAR15";
label variable PEGAP15 "COVERED BY EMPL UNION INS IN APR15";
label variable PEGMY15 "COVERED BY EMPL UNION INS IN MAY15";
label variable PEGJU15 "COVERED BY EMPL UNION INS IN JUN15";
label variable PEGJL15 "COVERED BY EMPL UNION INS IN JUL15";
label variable PEGAU15 "COVERED BY EMPL UNION INS IN AUG15";
label variable PEGSE15 "COVERED BY EMPL UNION INS IN SEP15";
label variable PEGOC15 "COVERED BY EMPL UNION INS IN OCT15";
label variable PEGNO15 "COVERED BY EMPL UNION INS IN NOV15";
label variable PEGDE15 "COVERED BY EMPL UNION INS IN DEC15";
label variable PDKJA15 "COVR BY PRIV INS (SOURCE UNKNWN) JAN15";
label variable PDKFE15 "COVR BY PRIV INS (SOURCE UNKNWN) FEB15";
label variable PDKMA15 "COVR BY PRIV INS (SOURCE UNKNWN) MAR15";
label variable PDKAP15 "COVR BY PRIV INS (SOURCE UNKNWN) APR15";
label variable PDKMY15 "COVR BY PRIV INS (SOURCE UNKNWN) MAY15";
label variable PDKJU15 "COVR BY PRIV INS (SOURCE UNKNWN) JUN15";
label variable PDKJL15 "COVR BY PRIV INS (SOURCE UNKNWN) JUL15";
label variable PDKAU15 "COVR BY PRIV INS (SOURCE UNKNWN) AUG15";
label variable PDKSE15 "COVR BY PRIV INS (SOURCE UNKNWN) SEP15";
label variable PDKOC15 "COVR BY PRIV INS (SOURCE UNKNWN) OCT15";
label variable PDKNO15 "COVR BY PRIV INS (SOURCE UNKNWN) NOV15";
label variable PDKDE15 "COVR BY PRIV INS (SOURCE UNKNWN) DEC15";
label variable PNGJA15 "COVERED BY NONGROUP INS IN JAN15";
label variable PNGFE15 "COVERED BY NONGROUP INS IN FEB15";
label variable PNGMA15 "COVERED BY NONGROUP INS IN MAR15";
label variable PNGAP15 "COVERED BY NONGROUP INS IN APR15";
label variable PNGMY15 "COVERED BY NONGROUP INS IN MAY15";
label variable PNGJU15 "COVERED BY NONGROUP INS IN JUN15";
label variable PNGJL15 "COVERED BY NONGROUP INS IN JUL15";
label variable PNGAU15 "COVERED BY NONGROUP INS IN AUG15";
label variable PNGSE15 "COVERED BY NONGROUP INS IN SEP15";
label variable PNGOC15 "COVERED BY NONGROUP INS IN OCT15";
label variable PNGNO15 "COVERED BY NONGROUP INS IN NOV15";
label variable PNGDE15 "COVERED BY NONGROUP INS IN DEC15";
label variable POGJA15 "COVERED BY OTHER GROUP INS IN JAN15";
label variable POGFE15 "COVERED BY OTHER GROUP INS IN FEB15";
label variable POGMA15 "COVERED BY OTHER GROUP INS IN MAR15";
label variable POGAP15 "COVERED BY OTHER GROUP INS IN APR15";
label variable POGMY15 "COVERED BY OTHER GROUP INS IN MAY15";
label variable POGJU15 "COVERED BY OTHER GROUP INS IN JUN15";
label variable POGJL15 "COVERED BY OTHER GROUP INS IN JUL15";
label variable POGAU15 "COVERED BY OTHER GROUP INS IN AUG15";
label variable POGSE15 "COVERED BY OTHER GROUP INS IN SEP15";
label variable POGOC15 "COVERED BY OTHER GROUP INS IN OCT15";
label variable POGNO15 "COVERED BY OTHER GROUP INS IN NOV15";
label variable POGDE15 "COVERED BY OTHER GROUP INS IN DEC15";
label variable PRSJA15 "COVERED BY SELF-EMP-1 INS IN JAN15";
label variable PRSFE15 "COVERED BY SELF-EMP-1 INS IN FEB15";
label variable PRSMA15 "COVERED BY SELF-EMP-1 INS IN MAR15";
label variable PRSAP15 "COVERED BY SELF-EMP-1 INS IN APR15";
label variable PRSMY15 "COVERED BY SELF-EMP-1 INS IN MAY15";
label variable PRSJU15 "COVERED BY SELF-EMP-1 INS IN JUN15";
label variable PRSJL15 "COVERED BY SELF-EMP-1 INS IN JUL15";
label variable PRSAU15 "COVERED BY SELF-EMP-1 INS IN AUG15";
label variable PRSSE15 "COVERED BY SELF-EMP-1 INS IN SEP15";
label variable PRSOC15 "COVERED BY SELF-EMP-1 INS IN OCT15";
label variable PRSNO15 "COVERED BY SELF-EMP-1 INS IN NOV15";
label variable PRSDE15 "COVERED BY SELF-EMP-1 INS IN DEC15";
label variable POUJA15 "COVERED BY HOLDER OUTSIDE OF RU IN JAN15";
label variable POUFE15 "COVERED BY HOLDER OUTSIDE OF RU IN FEB15";
label variable POUMA15 "COVERED BY HOLDER OUTSIDE OF RU IN MAR15";
label variable POUAP15 "COVERED BY HOLDER OUTSIDE OF RU IN APR15";
label variable POUMY15 "COVERED BY HOLDER OUTSIDE OF RU IN MAY15";
label variable POUJU15 "COVERED BY HOLDER OUTSIDE OF RU IN JUN15";
label variable POUJL15 "COVERED BY HOLDER OUTSIDE OF RU IN JUL15";
label variable POUAU15 "COVERED BY HOLDER OUTSIDE OF RU IN AUG15";
label variable POUSE15 "COVERED BY HOLDER OUTSIDE OF RU IN SEP15";
label variable POUOC15 "COVERED BY HOLDER OUTSIDE OF RU IN OCT15";
label variable POUNO15 "COVERED BY HOLDER OUTSIDE OF RU IN NOV15";
label variable POUDE15 "COVERED BY HOLDER OUTSIDE OF RU IN DEC15";
label variable PRXJA15 "COV BY PRIV INS THROUGH EXCHNG IN JAN15";
label variable PRXFE15 "COV BY PRIV INS THROUGH EXCHNG IN FEB15";
label variable PRXMA15 "COV BY PRIV INS THROUGH EXCHNG IN MAR15";
label variable PRXAP15 "COV BY PRIV INS THROUGH EXCHNG IN APR15";
label variable PRXMY15 "COV BY PRIV INS THROUGH EXCHNG IN MAY15";
label variable PRXJU15 "COV BY PRIV INS THROUGH EXCHNG IN JUN15";
label variable PRXJL15 "COV BY PRIV INS THROUGH EXCHNG IN JUL15";
label variable PRXAU15 "COV BY PRIV INS THROUGH EXCHNG IN AUG15";
label variable PRXSE15 "COV BY PRIV INS THROUGH EXCHNG IN SEP15";
label variable PRXOC15 "COV BY PRIV INS THROUGH EXCHNG IN OCT15";
label variable PRXNO15 "COV BY PRIV INS THROUGH EXCHNG IN NOV15";
label variable PRXDE15 "COV BY PRIV INS THROUGH EXCHNG IN DEC15";
label variable PRIJA15 "COVERED BY PRIVATE INS IN JAN15";
label variable PRIFE15 "COVERED BY PRIVATE INS IN FEB15";
label variable PRIMA15 "COVERED BY PRIVATE INS IN MAR15";
label variable PRIAP15 "COVERED BY PRIVATE INS IN APR15";
label variable PRIMY15 "COVERED BY PRIVATE INS IN MAY15";
label variable PRIJU15 "COVERED BY PRIVATE INS IN JUN15";
label variable PRIJL15 "COVERED BY PRIVATE INS IN JUL15";
label variable PRIAU15 "COVERED BY PRIVATE INS IN AUG15";
label variable PRISE15 "COVERED BY PRIVATE INS IN SEP15";
label variable PRIOC15 "COVERED BY PRIVATE INS IN OCT15";
label variable PRINO15 "COVERED BY PRIVATE INS IN NOV15";
label variable PRIDE15 "COVERED BY PRIVATE INS IN DEC15";
label variable HPEJA15 "HOLDER OF EMPL UNION INS IN JAN15";
label variable HPEFE15 "HOLDER OF EMPL UNION INS IN FEB15";
label variable HPEMA15 "HOLDER OF EMPL UNION INS IN MAR15";
label variable HPEAP15 "HOLDER OF EMPL UNION INS IN APR15";
label variable HPEMY15 "HOLDER OF EMPL UNION INS IN MAY15";
label variable HPEJU15 "HOLDER OF EMPL UNION INS IN JUN15";
label variable HPEJL15 "HOLDER OF EMPL UNION INS IN JUL15";
label variable HPEAU15 "HOLDER OF EMPL UNION INS IN AUG15";
label variable HPESE15 "HOLDER OF EMPL UNION INS IN SEP15";
label variable HPEOC15 "HOLDER OF EMPL UNION INS IN OCT15";
label variable HPENO15 "HOLDER OF EMPL UNION INS IN NOV15";
label variable HPEDE15 "HOLDER OF EMPL UNION INS IN DEC15";
label variable HPDJA15 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN15";
label variable HPDFE15 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB15";
label variable HPDMA15 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR15";
label variable HPDAP15 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR15";
label variable HPDMY15 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY15";
label variable HPDJU15 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN15";
label variable HPDJL15 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL15";
label variable HPDAU15 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG15";
label variable HPDSE15 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP15";
label variable HPDOC15 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT15";
label variable HPDNO15 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV15";
label variable HPDDE15 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC15";
label variable HPNJA15 "HOLDER OF NONGROUP INS IN JAN15";
label variable HPNFE15 "HOLDER OF NONGROUP INS IN FEB15";
label variable HPNMA15 "HOLDER OF NONGROUP INS IN MAR15";
label variable HPNAP15 "HOLDER OF NONGROUP INS IN APR15";
label variable HPNMY15 "HOLDER OF NONGROUP INS IN MAY15";
label variable HPNJU15 "HOLDER OF NONGROUP INS IN JUN15";
label variable HPNJL15 "HOLDER OF NONGROUP INS IN JUL15";
label variable HPNAU15 "HOLDER OF NONGROUP INS IN AUG15";
label variable HPNSE15 "HOLDER OF NONGROUP INS IN SEP15";
label variable HPNOC15 "HOLDER OF NONGROUP INS IN OCT15";
label variable HPNNO15 "HOLDER OF NONGROUP INS IN NOV15";
label variable HPNDE15 "HOLDER OF NONGROUP INS IN DEC15";
label variable HPOJA15 "HOLDER OF OTHER GROUP INS IN JAN15";
label variable HPOFE15 "HOLDER OF OTHER GROUP INS IN FEB15";
label variable HPOMA15 "HOLDER OF OTHER GROUP INS IN MAR15";
label variable HPOAP15 "HOLDER OF OTHER GROUP INS IN APR15";
label variable HPOMY15 "HOLDER OF OTHER GROUP INS IN MAY15";
label variable HPOJU15 "HOLDER OF OTHER GROUP INS IN JUN15";
label variable HPOJL15 "HOLDER OF OTHER GROUP INS IN JUL15";
label variable HPOAU15 "HOLDER OF OTHER GROUP INS IN AUG15";
label variable HPOSE15 "HOLDER OF OTHER GROUP INS IN SEP15";
label variable HPOOC15 "HOLDER OF OTHER GROUP INS IN OCT15";
label variable HPONO15 "HOLDER OF OTHER GROUP INS IN NOV15";
label variable HPODE15 "HOLDER OF OTHER GROUP INS IN DEC15";
label variable HPSJA15 "HOLDER OF SELF-EMP-1 INS IN JAN15";
label variable HPSFE15 "HOLDER OF SELF-EMP-1 INS IN FEB15";
label variable HPSMA15 "HOLDER OF SELF-EMP-1 INS IN MAR15";
label variable HPSAP15 "HOLDER OF SELF-EMP-1 INS IN APR15";
label variable HPSMY15 "HOLDER OF SELF-EMP-1 INS IN MAY15";
label variable HPSJU15 "HOLDER OF SELF-EMP-1 INS IN JUN15";
label variable HPSJL15 "HOLDER OF SELF-EMP-1 INS IN JUL15";
label variable HPSAU15 "HOLDER OF SELF-EMP-1 INS IN AUG15";
label variable HPSSE15 "HOLDER OF SELF-EMP-1 INS IN SEP15";
label variable HPSOC15 "HOLDER OF SELF-EMP-1 INS IN OCT15";
label variable HPSNO15 "HOLDER OF SELF-EMP-1 INS IN NOV15";
label variable HPSDE15 "HOLDER OF SELF-EMP-1 INS IN DEC15";
label variable HPXJA15 "HOLDER OF PRIV INS THROUGH EXCH IN JAN15";
label variable HPXFE15 "HOLDER OF PRIV INS THROUGH EXCH IN FEB15";
label variable HPXMA15 "HOLDER OF PRIV INS THROUGH EXCH IN MAR15";
label variable HPXAP15 "HOLDER OF PRIV INS THROUGH EXCH IN APR15";
label variable HPXMY15 "HOLDER OF PRIV INS THROUGH EXCH IN MAY15";
label variable HPXJU15 "HOLDER OF PRIV INS THROUGH EXCH IN JUN15";
label variable HPXJL15 "HOLDER OF PRIV INS THROUGH EXCH IN JUL15";
label variable HPXAU15 "HOLDER OF PRIV INS THROUGH EXCH IN AUG15";
label variable HPXSE15 "HOLDER OF PRIV INS THROUGH EXCH IN SEP15";
label variable HPXOC15 "HOLDER OF PRIV INS THROUGH EXCH IN OCT15";
label variable HPXNO15 "HOLDER OF PRIV INS THROUGH EXCH IN NOV15";
label variable HPXDE15 "HOLDER OF PRIV INS THROUGH EXCH IN DEC15";
label variable HPRJA15 "HOLDER OF PRIVATE INSURANCE IN JAN15";
label variable HPRFE15 "HOLDER OF PRIVATE INSURANCE IN FEB15";
label variable HPRMA15 "HOLDER OF PRIVATE INSURANCE IN MAR15";
label variable HPRAP15 "HOLDER OF PRIVATE INSURANCE IN APR15";
label variable HPRMY15 "HOLDER OF PRIVATE INSURANCE IN MAY15";
label variable HPRJU15 "HOLDER OF PRIVATE INSURANCE IN JUN15";
label variable HPRJL15 "HOLDER OF PRIVATE INSURANCE IN JUL15";
label variable HPRAU15 "HOLDER OF PRIVATE INSURANCE IN AUG15";
label variable HPRSE15 "HOLDER OF PRIVATE INSURANCE IN SEP15";
label variable HPROC15 "HOLDER OF PRIVATE INSURANCE IN OCT15";
label variable HPRNO15 "HOLDER OF PRIVATE INSURANCE IN NOV15";
label variable HPRDE15 "HOLDER OF PRIVATE INSURANCE IN DEC15";
label variable INSJA15X "COVR BY HOSP/MED INS IN JAN15 (ED)";
label variable INSFE15X "COVR BY HOSP/MED INS IN FEB15 (ED)";
label variable INSMA15X "COVR BY HOSP/MED INS IN MAR15 (ED)";
label variable INSAP15X "COVR BY HOSP/MED INS IN APR15 (ED)";
label variable INSMY15X "COVR BY HOSP/MED INS IN MAY15 (ED)";
label variable INSJU15X "COVR BY HOSP/MED INS IN JUN15 (ED)";
label variable INSJL15X "COVR BY HOSP/MED INS IN JUL15 (ED)";
label variable INSAU15X "COVR BY HOSP/MED INS IN AUG15 (ED)";
label variable INSSE15X "COVR BY HOSP/MED INS IN SEP15 (ED)";
label variable INSOC15X "COVR BY HOSP/MED INS IN OCT15 (ED)";
label variable INSNO15X "COVR BY HOSP/MED INS IN NOV15 (ED)";
label variable INSDE15X "COVR BY HOSP/MED INS IN DEC15 (ED)";
label variable PRVEV15 "EVER HAVE PRIVATE INSURANCE DURING 2015";
label variable TRIEV15 "EVER HAVE TRICARE/CHAMPVA DURING 2015";
label variable MCREV15 "EVER HAVE MEDICARE DURING 2015 (ED)";
label variable MCDEV15 "EVER HAVE MCAID/SCHIP DURING 2015 (ED)";
label variable OPAEV15 "EVER HAVE OTHER PUBLIC A INS DURING 2015";
label variable OPBEV15 "EVER HAVE OTHER PUBLIC B INS DURING 2015";
label variable UNINS15 "UNINSURED ALL OF 2015";
label variable INSCOV15 "HEALTH INSURANCE COVERAGE INDICATOR 2015";
label variable INSURC15 "FULL YEAR INSURANCE COVERAGE STATUS 2015";
label variable TRIST31X "COV BY TRICARE STANDARD-ANY TIME IN R3/1";
label variable TRIST42X "COV BY TRICARE STANDARD-ANY TIME IN R4/2";
label variable TRIST15X "CV BY TRICARE STANDARD-R5/3 TIL 12/31/15";
label variable TRIPR31X "COV BY TRICARE PRIME - ANY TIME IN R3/1";
label variable TRIPR42X "COV BY TRICARE PRIME - ANY TIME IN R4/2";
label variable TRIPR15X "COV BY TRICARE PRIME-R5/3 UNTIL 12/31/15";
label variable TRIEX31X "COV BY TRICARE EXTRA - ANY TIME IN R3/1";
label variable TRIEX42X "COV BY TRICARE EXTRA - ANY TIME IN R4/2";
label variable TRIEX15X "COV BY TRICARE EXTRA - R5/3 TIL 12/31/15";
label variable TRILI31X "COV BY TRICARE FOR LIFE-ANY TIME IN R3/1";
label variable TRILI42X "COV BY TRICARE FOR LIFE-ANY TIME IN R4/2";
label variable TRILI15X "CV BY TRICARE FOR LIFE-R5/3 TIL 12/31/15";
label variable TRICH31X "COVERED BY CHAMPVA - ANY TIME IN R3/1";
label variable TRICH42X "COVERED BY CHAMPVA - ANY TIME IN R4/2";
label variable TRICH15X "COVERED BY CHAMPVA - R5/3 UNTIL 12/31/15";
label variable MCRPD31 "COV BY MEDICARE PMED BENEFIT - R3/1";
label variable MCRPD42 "COV BY MEDICARE PMED BENEFIT - R4/2";
label variable MCRPD15 "COV BY MEDICARE PMED BENEFIT - 12/31/15";
label variable MCRPD31X "COV BY MEDICARE PMED BENEFIT - R3/1 (ED)";
label variable MCRPD42X "COV BY MEDICARE PMED BENEFIT - R4/2 (ED)";
label variable MCRPD15X "COV BY MCARE PMED BENEFIT-12/31/15 (ED)";
label variable MCRPB31 "COV BY MEDICARE PART B - R3/1";
label variable MCRPB42 "COV BY MEDICARE PART B - R4/2";
label variable MCRPB15 "COV BY MEDICARE PART B - 12/31/15";
label variable MCRPHO31 "COV BY MEDICARE MANAGED CARE - R3/1";
label variable MCRPHO42 "COV BY MEDICARE MANAGED CARE - R4/2";
label variable MCRPHO15 "COV BY MEDICARE MANAGED CARE - 12/31/15";
label variable MCDHMO31 "COV BY MCAID/SCHIP HMO -ANY TIME IN R3/1";
label variable MCDHMO42 "COV BY MCAID/SCHIP HMO -ANY TIME IN R4/2";
label variable MCDHMO15 "COV BY MCAID/SCHIP HMO-R5/3 TIL 12/31/15";
label variable MCDMC31 "CV MCAID/CHIP GTKPR PLN-ANY TIME IN R3/1";
label variable MCDMC42 "CV MCAID/CHIP GTKPR PLN-ANY TIME IN R4/2";
label variable MCDMC15 "CV MCD/CHIP GTKPR PLN-R5/3 TIL 12/31/15";
label variable PRVHMO31 "COVERED BY PRIVATE HMO-ANY TIME IN R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO-ANY TIME IN R4/2";
label variable PRVHMO15 "COVERED BY PRIVATE HMO-R5/3 TIL 12/31/15";
label variable FSAGT31 "ANYONE IN RU HAVE FSA - R3/1";
label variable HASFSA31 "PERSON IS FSA HOLDER - R3/1";
label variable FSAAMT31 "FSA TOTAL AMOUNT FOR RU - R3/1";
label variable PROBPY42 "FAMILY HAVING PROB PAYING MEDICAL BILLS";
label variable CRFMPY42 "FAMILY MED BILLS BEING PAID OVER TIME";
label variable PYUNBL42 "UNABLE TO PAY FAMILY MEDICAL BILLS";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 20 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PNL 20 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 20 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PN 20 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 20 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PNL 20 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PNL 20 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PNL 20 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PN 20 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PNL 20 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PNL 20 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PNL 20 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PNL 20 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PNL 20 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PNL 20 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PNL 20 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 20 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 20 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-P20 ONLY";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 20 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 20 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 20 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 20 ONLY";
label variable TRICR31X "COV BY TRICR/CHAMV - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICR/CHAMV - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICR/CHAMV 12-31/R3 INT DT (ED)";
label variable TRICR15X "COV BY TRICR/CHAMV - 12/31/15 (ED)";
label variable TRIAT31X "COV TRICARE/CHAMPVA - ANY TIME IN R3/1";
label variable TRIAT42X "COV TRICARE/CHAMPVA - ANY TIME IN R4/2";
label variable TRIAT53X "COV TRICARE/CHAMPVA - ANY TIME IN R5/3";
label variable TRIAT15X "COV TRICARE/CHAMPVA-R5/3 UNTIL 12/31/15";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID15 "COV BY MEDICAID OR SCHIP - 12/31/15";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID15X "COV BY MEDICAID OR SCHIP - 12/31/15 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE15 "COV BY MEDICARE - 12/31/15";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE15X "COV BY MEDICARE - 12/31/15 (ED)";
label variable MCDAT31X "COV MEDICAID OR SCHIP - ANY TIME IN R3/1";
label variable MCDAT42X "COV MEDICAID OR SCHIP - ANY TIME IN R4/2";
label variable MCDAT53X "COV MEDICAID OR SCHIP - ANY TIME IN R5/3";
label variable MCDAT15X "CV MCD/CHIP-ANY TME IN R5/3 TIL 12/31/15";
label variable OTPAAT31 "COV OT GOV MCD/CHIP HMO-ANY TIME IN R3/1";
label variable OTPAAT42 "COV OT GOV MCD/CHIP HMO-ANY TIME IN R4/2";
label variable OTPAAT53 "COV OT GOV MCD/CHIP HMO-ANY TIME IN R5/3";
label variable OTPAAT15 "CV OT GOV MCD/CHIP HMO-R5/3 TIL 12/31/15";
label variable OTPBAT31 "CV OTGV NT MCD/CHIP HMO-ANY TIME IN R3/1";
label variable OTPBAT42 "CV OTGV NT MCD/CHIP HMO-ANY TIME IN R4/2";
label variable OTPBAT53 "CV OTGV NT MCD/CHIP HMO-ANY TIME IN R5/3";
label variable OTPBAT15 "CV OTGV NT MCD/CHP HMO-R5/3 TIL 12/31/15";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA15 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/15";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB15 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/15";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK15 "COV BY PRIV INS (DK PLAN) - 12/31/15";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU15 "COV BY EMPL/UNION GRP INS - 12/31/15";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING15 "COV BY NON-GROUP INS - 12/31/15";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG15 "COV BY OTHER GROUP INS - 12/31/15";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS15 "COV BY SELF-EMP-1 INS - 12/31/15";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT15 "COV BY SOMEONE OUT OF RU - 12/31/15";
label variable PRSTX31 "COV BY PRIV EXCHANGE INS -R3/1 INT DT";
label variable PRSTX42 "COV BY PRIV EXCHANGE INS -R4/2 INT DT";
label variable PRSTX53 "PRIV EXCHANGE INS ON 12-31 R5/R3 INT DT";
label variable PRSTX15 "PRIV EXCHANGE INSURANCE ON 12/31/15";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV15 "COV BY PRIV HLTH INS - 12/31/15";
label variable PRIVAT31 "COV BY PRIVATE INS - ANY TIME IN R3/1";
label variable PRIVAT42 "COV BY PRIVATE INS - ANY TIME IN R4/2";
label variable PRIVAT53 "COV BY PRIVATE INS - ANY TIME IN R5/3";
label variable PRIVAT15 "COV BY PRIVATE INS - R5/3 UNTIL 12/31/15";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB15X "COV BY PUBLIC INS - 12/31/15 (ED)";
label variable PUBAT31X "COV BY PUBLIC - ANY TIME IN R3/1";
label variable PUBAT42X "COV BY PUBLIC - ANY TIME IN R4/2";
label variable PUBAT53X "COV BY PUBLIC - ANY TIME IN R5/3";
label variable PUBAT15X "COV BY PUBLIC - R5/3 UNTIL 12/31/15";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS15X "INSURED - 12/31/15 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT15X "INSURED ANY TIME IN R5/R3 UNTIL 12/31/15";
label variable STAPR31 "COV BY STATE-SPEC PROG - R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG - R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR15 "COV BY STATE-SPEC PROG - 12/31/15";
label variable STPRAT31 "COVERAGE BY STATE INS - ANY TIME IN R3/1";
label variable STPRAT42 "COVERAGE BY STATE INS - ANY TIME IN R4/2";
label variable STPRAT53 "COVERAGE BY STATE INS - ANY TIME IN R5/3";
label variable STPRAT15 "COV BY STATE INS - R5/3 UNTIL 12/31/15";
label variable DENTIN31 "DENTAL INSURANCE - ANY TIME IN RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - ANY TIME IN RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - ANY TIME IN RD 5/3";
label variable DNTINS31 "DENTAL INS - ANY TIME IN RD 3/1 IN 2015";
label variable DNTINS15 "DENTL INS-ANY TIME IN R5/R3 TIL 12/31/15";
label variable PMEDIN31 "PMED INS - ANY TIME IN RD 3/1";
label variable PMEDIN42 "PMEDINS - ANY TIME IN RD 4/2";
label variable PMEDIN53 "PMEDINS - ANY TIME IN RD 5/3";
label variable PMDINS31 "PMED INS - RD 3/1 IN 2015";
label variable PMDINS15 "PMED INS - R5/R3 UNTIL 12/31/15";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable TOTTCH15 "TOTAL HEALTH CARE CHARGES 15, EXCL RX";
label variable TOTEXP15 "TOTAL HEALTH CARE EXP 15";
label variable TOTSLF15 "TOTAL AMT PAID BY SELF/FAMILY 15";
label variable TOTMCR15 "TOTAL AMT PAID BY MEDICARE 15";
label variable TOTMCD15 "TOTAL AMT PAID BY MEDICAID 15";
label variable TOTPRV15 "TOTAL AMT PAID BY PRIVATE INS 15";
label variable TOTVA15 "TOTAL AMT PAID BY VA/CHAMPVA 15";
label variable TOTTRI15 "TOTAL AMT PAID BY TRICARE 15";
label variable TOTOFD15 "TOTAL AMT PAID BY OTHER FEDERAL 15";
label variable TOTSTL15 "TOTAL AMT PAID BY OTH ST/LOCAL 15";
label variable TOTWCP15 "TOTAL AMT PAID BY WORKERS COMP 15";
label variable TOTOPR15 "TOTAL AMT PAID BY OTHER PRIVATE 15";
label variable TOTOPU15 "TOTAL AMT PAID BY OTHER PUBLIC 15";
label variable TOTOSR15 "TOTAL AMT PAID BY OTHER SOURCES 15";
label variable TOTPTR15 "TOTAL AMT PAID BY PRV & TRI 15";
label variable TOTOTH15 "TOTAL AMT PAID BY OTH COMBINED 15";
label variable OBTOTV15 "# OFFICE-BASED PROVIDER VISITS 15";
label variable OBVTCH15 "OFFICE-BASED PROVIDER VISIT CHARGES 15";
label variable OBVEXP15 "TOTAL OFFICE-BASED EXP 15";
label variable OBVSLF15 "ALL OFFICE VISITS - SELF/FAMILY AMT 15";
label variable OBVMCR15 "ALL OFFICE VISITS - MEDICARE AMT 15";
label variable OBVMCD15 "ALL OFFICE VISITS - MEDICAID AMT 15";
label variable OBVPRV15 "ALL OFFICE VISITS - PRIVATE INS AMT 15";
label variable OBVVA15 "ALL OFFICE VISITS-VA/CHAMPVA AMT 15";
label variable OBVTRI15 "ALL OFFICE VISITS-TRICARE AMT 15";
label variable OBVOFD15 "ALL OFFICE VISITS-OTHER FEDERAL AMT 15";
label variable OBVSTL15 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 15";
label variable OBVWCP15 "ALL OFFICE VISITS - WORKERS COMP AMT 15";
label variable OBVOPR15 "ALL OFFICE VISITS - OTH PRIVATE AMT 15";
label variable OBVOPU15 "ALL OFFICE VISITS - OTH PUBLIC AMT 15";
label variable OBVOSR15 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 15";
label variable OBVPTR15 "ALL OFFICE VISITS - PRV & TRI AMT 15";
label variable OBVOTH15 "ALL OFFICE VISITS - OTH COMBINED AMT 15";
label variable OBDRV15 "# OFFICE-BASED PHYSICIAN VISITS 15";
label variable OBDTCH15 "OFFICE-BASED PHYSICIAN VISIT CHARGES 15";
label variable OBDEXP15 "TOTAL OFF-BASED DR EXP 15";
label variable OBDSLF15 "DR OFFICE VISITS - SELF/FAMILY AMT 15";
label variable OBDMCR15 "DR OFFICE VISITS - MEDICARE AMT 15";
label variable OBDMCD15 "DR OFFICE VISITS - MEDICAID AMT 15";
label variable OBDPRV15 "DR OFFICE VISITS - PRIVATE INS AMT 15";
label variable OBDVA15 "DR OFFICE VISITS - VA/CHAMPVA AMT 15";
label variable OBDTRI15 "DR OFFICE VISITS - TRICARE AMT 15";
label variable OBDOFD15 "DR OFFICE VISITS - OTHER FEDERAL AMT 15";
label variable OBDSTL15 "DR OFFICE VISITS - OTH ST/LOCAL AMT 15";
label variable OBDWCP15 "DR OFFICE VISITS - WORKERS COMP AMT 15";
label variable OBDOPR15 "DR OFFICE VISITS - OTH PRIVATE AMT 15";
label variable OBDOPU15 "DR OFFICE VISITS - OTH PUBLIC AMT 15";
label variable OBDOSR15 "DR OFF VSTS - OTH UNCLASS SRCE AMT 15";
label variable OBDPTR15 "DR OFFICE VISITS - PRV & TRI AMT 15";
label variable OBDOTH15 "DR OFFICE VISITS - OTH COMBINED AMT 15";
label variable OBOTHV15 "# OFFICE-BASED NON-PHYSICAN VISITS 15";
label variable OBOTCH15 "OFFICE-BASED NON-DR VISIT CHARGES 15";
label variable OBOEXP15 "TOTAL OFF-BASED NON-DR EXP 15";
label variable OBOSLF15 "NON-DR OFF VISTS - SELF/FAMILY AMT 15";
label variable OBOMCR15 "NON-DR OFF VISTS - MEDICARE AMT 15";
label variable OBOMCD15 "NON-DR OFF VISTS - MEDICAID AMT 15";
label variable OBOPRV15 "NON-DR OFF VISTS - PRIVATE INS AMT 15";
label variable OBOVA15 "NON-DR OFF VISTS - VA/CHAMPVA AMT 15";
label variable OBOTRI15 "NON-DR OFF VISTS - TRICARE AMT 15";
label variable OBOOFD15 "NON-DR OFF VISTS - OTHER FEDERAL AMT 15";
label variable OBOSTL15 "NON-DR OFF VISTS - OTH ST/LOCAL AMT 15";
label variable OBOWCP15 "NON-DR OFF VISTS - WORKERS COMP AMT 15";
label variable OBOOPR15 "NON-DR OFF VISTS - OTH PRIVATE AMT 15";
label variable OBOOPU15 "NON-DR OFF VISTS - OTH PUBLIC AMT 15";
label variable OBOOSR15 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 15";
label variable OBOPTR15 "NON-DR OFF VISTS - PRV & TRI AMT 15";
label variable OBOOTH15 "NON-DR OFF VISTS - OTH COMBINED AMT 15";
label variable OBCHIR15 "# OFFICE-BASED CHIROPRACTOR VISITS 15";
label variable OBCTCH15 "OFFICE-BASED CHIRO VISIT CHARGES 15";
label variable OBCEXP15 "TOTAL OFF-BASED CHIRO EXP 15";
label variable OBCSLF15 "CHIRO OFF VISITS - SELF/FAMILY AMT 15";
label variable OBCMCR15 "CHIRO OFF VISITS - MEDICARE AMT 15";
label variable OBCMCD15 "CHIRO OFF VISITS - MEDICAID AMT 15";
label variable OBCPRV15 "CHIRO OFF VISITS - PRIVATE INS AMT 15";
label variable OBCVA15 "CHIRO OFF VISITS - VA/CHAMPVA AMT 15";
label variable OBCTRI15 "CHIRO OFF VISITS - TRICARE AMT 15";
label variable OBCOFD15 "CHIRO OFF VISITS - OTHER FEDERAL AMT 15";
label variable OBCSTL15 "CHIRO OFF VISITS - OTH ST/LOCAL AMT 15";
label variable OBCWCP15 "CHIRO OFF VISITS - WORKERS COMP AMT 15";
label variable OBCOPR15 "CHIRO OFF VISTS - OTHR PRIVATE AMT 15";
label variable OBCOPU15 "CHIRO OFF VISTS - OTHR PUBLIC AMT 15";
label variable OBCOSR15 "CHIRO OFF VSTS-OTHR UNCLASS SRCE AMT 15";
label variable OBCPTR15 "CHIRO OFF VISITS - PRV & TRI AMT 15";
label variable OBCOTH15 "CHIRO OFF VISITS -OTH COMBINED AMT 15";
label variable OBNURS15 "# OFF-BASED NURSE/PRACTITIONER VISITS 15";
label variable OBNTCH15 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 15";
label variable OBNEXP15 "TOTAL OFF-BASED NURSE/PRAC 15";
label variable OBNSLF15 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 15";
label variable OBNMCR15 "NURSE/PRAC OFF VISITS - MEDICARE AMT 15";
label variable OBNMCD15 "NURSE/PRAC OFF VSTS - MEDICAID AMT 15";
label variable OBNPRV15 "NURSE/PRAC OFF VSTS-PRIVATE INS AMT 15";
label variable OBNVA15 "NURSE/PRAC OFF VSTS - VA/CHAMPVA AMT 15";
label variable OBNTRI15 "NURSE/PRAC OFF VSTS - TRICARE AMT 15";
label variable OBNOFD15 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 15";
label variable OBNSTL15 "NURSE/PRAC OFF VSTS-OTH ST/LOCAL AMT 15";
label variable OBNWCP15 "NURSE/PRAC OFF VSTS-WORKERS COMP AMT 15";
label variable OBNOPR15 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 15";
label variable OBNOPU15 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 15";
label variable OBNOSR15 "NRS/PR OFF VSTS-OTH UNCLASS SRCE AMT 15";
label variable OBNPTR15 "NURSE/PRAC OFF VSTS - PRV & TRI AMT 15";
label variable OBNOTH15 "NURSE/PRAC OFF VSTS-OTH COMBINED AMT 15";
label variable OBOPTO15 "# OFF-BASED OPTOMETRIST VISITS 15";
label variable OBETCH15 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 15";
label variable OBEEXP15 "TOTAL OFF-BASED OPTOMETRIST EXP 15";
label variable OBESLF15 "OPTOMETRIST OFF VSTS-SELF/FAMILY AMT 15";
label variable OBEMCR15 "OPTOMETRIST OFF VSTS - MEDICARE AMT 15";
label variable OBEMCD15 "OPTOMETRIST OFF VSTS - MEDICAID AMT 15";
label variable OBEPRV15 "OPTOMETRIST OFF VSTS-PRIVATE INS AMT 15";
label variable OBEVA15 "OPTOMETRIST OFF VSTS - VA/CHAMPVA AMT 15";
label variable OBETRI15 "OPTOMETRIST OFF VSTS - TRICARE AMT 15";
label variable OBEOFD15 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 15";
label variable OBESTL15 "OPTOMETRIST OFF VSTS-OTH ST/LOCL AMT 15";
label variable OBEWCP15 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 15";
label variable OBEOPR15 "OPTOMETRIST OFF VSTS-OTH PRIVATE AMT 15";
label variable OBEOPU15 "OPTOMETRIST OFF VSTS - OTH PUBLIC AMT 15";
label variable OBEOSR15 "OPTOM OFF VSTS-OTH UNCLASS SRCE AMT 15";
label variable OBEPTR15 "OPTOMETRIST OFF VSTS - PRV & TRI AMT 15";
label variable OBEOTH15 "OPTOMETRIST OFF VSTS-OTH COMBINED AMT 15";
label variable OBASST15 "# OFF-BASED PHYSICIAN ASSIST VISITS 15";
label variable OBATCH15 "OFFICE-BASED PHYS ASST VISIT CHARGES 15";
label variable OBAEXP15 "TOTAL OFF-BASED PHYS ASS T EXP 15";
label variable OBASLF15 "PHYS ASS T OFF VSTS - SELF/FAMILY AMT 15";
label variable OBAMCR15 "PHYS ASS T OFF VSTS - MEDICARE AMT 15";
label variable OBAMCD15 "PHYS ASS T OFF VSTS - MEDICAID AMT 15";
label variable OBAPRV15 "PHYS ASS T OFF VSTS - PRIVATE INS AMT 15";
label variable OBAVA15 "PHYS ASS T OFF VSTS - VA/CHAMPVA AMT 15";
label variable OBATRI15 "PHYS ASS T OFF VSTS - TRICARE AMT 15";
label variable OBAOFD15 "PHYS ASS T OFF VSTS - OTHER FED AMT 15";
label variable OBASTL15 "PHYS ASS T OFF VSTS - OTH ST/LOCL AMT 15";
label variable OBAWCP15 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 15";
label variable OBAOPR15 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 15";
label variable OBAOPU15 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 15";
label variable OBAOSR15 "P A OFF VSTS - OTH UNCLASS SRCE AMT 15";
label variable OBAPTR15 "PHYS ASST OFF VSTS - PRV & TRI AMT 15";
label variable OBAOTH15 "PHYS ASST OFF VSTS - OTH COMBINED AMT 15";
label variable OBTHER15 "# OFF-BASED PT/OT VISITS 15";
label variable OBTTCH15 "OFFICE-BASED PT/OC VISIT CHARGES 15";
label variable OBTEXP15 "TOT OFF-BASED PT EXP 15";
label variable OBTSLF15 "PT/OT OFF VISITS - SELF/FAMILY AMT 15";
label variable OBTMCR15 "PT/OT OFF VISITS - MEDICARE AMT 15";
label variable OBTMCD15 "PT/OT OFF VISITS - MEDICAID AMT 15";
label variable OBTPRV15 "PT/OT OFF VISITS - PRIVATE INS AMT 15";
label variable OBTVA15 "PT/OT OFF VISITS - VA/CHAMPVA AMT 15";
label variable OBTTRI15 "PT/OT OFF VISITS - TRICARE AMT 15";
label variable OBTOFD15 "PT/OT OFF VISITS - OTHER FED AMT 15";
label variable OBTSTL15 "PT/OT OFF VISITS - OTH ST/LOCL AMT 15";
label variable OBTWCP15 "PT/OT OFF VISITS - WORKERS COMP AMT 15";
label variable OBTOPR15 "PT/OT OFF VISITS - OTH PRIVATE AMT 15";
label variable OBTOPU15 "PT/OT OFF VISITS - OTH PUBLIC AMT 15";
label variable OBTOSR15 "PT/OT OFF VSTS-OTH UNCLASS SRCE AMT 15";
label variable OBTPTR15 "PT/OT OFF VISITS - PRV & TRI AMT 15";
label variable OBTOTH15 "PT/OT OFF VISITS - OTH COMBINED AMT 15";
label variable OPTOTV15 "# OUTPATIENT DEPT PROVIDER VISITS 15";
label variable OPTTCH15 "OPD FACILITY + DR VISIT CHARGES - 15";
label variable OPTEXP15 "TOTAL OUTPATIENT FAC + DR EXP 15";
label variable OPTSLF15 "ALL OPD VSTS-SELF/FAMILY AMT-(FAC+DR) 15";
label variable OPTMCR15 "ALL OPD VSTS-MEDICARE AMT-(FAC+DR) 15";
label variable OPTMCD15 "ALL OPD VSTS-MEDICAID AMT-(FAC+DR) 15";
label variable OPTPRV15 "ALL OPD VSTS-PRIV INS AMT-(FAC+DR) 15";
label variable OPTVA15 "ALL OPD VSTS-VA/CHAMPVA AMT-(FAC+DR) 15";
label variable OPTTRI15 "ALL OPD VSTS-TRICARE AMT-(FAC+DR) 15";
label variable OPTOFD15 "ALL OPD VSTS-OTHER FED AMT-(FAC+DR) 15";
label variable OPTSTL15 "ALL OPD VST-OTH ST/LOCAL AMT(FAC+DR) 15";
label variable OPTWCP15 "ALL OPD VST-WORKRS COMP AMT-(FAC+DR) 15";
label variable OPTOPR15 "ALL OPD VSTS-OTH PRIVATE AMT-(FAC+DR) 15";
label variable OPTOPU15 "ALL OPD VSTS-OTH PUBLIC AMT-(FAC+DR) 15";
label variable OPTOSR15 "ALL OPD VST-OTH UNCLS SRC AMT(FAC+DR) 15";
label variable OPTPTR15 "ALL OPD VISITS-PRV & TRI AMT (FAC+DR) 15";
label variable OPTOTH15 "ALL OPD VSTS-OTH COMBINED AMT(FAC+DR) 15";
label variable OPFTCH15 "OPD PROVIDER VISIT CHARGES - FAC 15";
label variable OPFEXP15 "TOTAL OUTPATIENT FACILITY EXP 15";
label variable OPFSLF15 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 15";
label variable OPFMCR15 "ALL OPD VISITS-MEDICARE AMT-FAC 15";
label variable OPFMCD15 "ALL OPD VISITS-MEDICAID AMT-FAC 15";
label variable OPFPRV15 "ALL OPD VISITS-PRIV INS AMT-FAC 15";
label variable OPFVA15 "ALL OPD VISITS-VA/CHAMPVA AMT-FAC 15";
label variable OPFTRI15 "ALL OPD VISITS-TRICARE AMT-FAC 15";
label variable OPFOFD15 "ALL OPD VISITS-OTHER FED AMT-FAC 15";
label variable OPFSTL15 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 15";
label variable OPFWCP15 "ALL OPD VISITS-WORKERS COMP AMT-FAC 15";
label variable OPFOPR15 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 15";
label variable OPFOPU15 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 15";
label variable OPFOSR15 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 15";
label variable OPFPTR15 "ALL OPD VISITS - PRV & TRI AMT-FAC 15";
label variable OPFOTH15 "ALL OPD VISITS - OTH COMBINED AMT-FAC 15";
label variable OPDEXP15 "TOTAL OUTPATIENT PROVIDER EXP 15";
label variable OPDTCH15 "OPD PROVIDER VISIT CHARGES - DR 15";
label variable OPDSLF15 "ALL OPD VISITS-SELF/FAMILY AMT-DR 15";
label variable OPDMCR15 "ALL OPD VISITS-MEDICARE AMT-DR 15";
label variable OPDMCD15 "ALL OPD VISITS-MEDICAID AMT-DR 15";
label variable OPDPRV15 "ALL OPD VISITS-PRIV INS AMT-DR 15";
label variable OPDVA15 "ALL OPD VISITS-VA/CHAMPVA AMT-DR 15";
label variable OPDTRI15 "ALL OPD VISITS-TRICARE AMT-DR 15";
label variable OPDOFD15 "ALL OPD VISITS-OTHER FED AMT-DR 15";
label variable OPDSTL15 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 15";
label variable OPDWCP15 "ALL OPD VISITS-WORKERS COMP AMT-DR 15";
label variable OPDOPR15 "ALL OPD VISITS - OTH PRIVATE AMT-DR 15";
label variable OPDOPU15 "ALL OPD VISITS-OTH PUBLIC AMT-DR 15";
label variable OPDOSR15 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 15";
label variable OPDPTR15 "ALL OPD VISITS-PRV & TRI AMT -DR 15";
label variable OPDOTH15 "ALL OPD VISITS-OTH COMBINED AMT-DR 15";
label variable OPDRV15 "# OUTPATIENT DEPT PHYSICIAN VISITS 15";
label variable OPVTCH15 "OPD PHYSICIAN VISIT CHARGES - FAC 15";
label variable OPVEXP15 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 15";
label variable OPVSLF15 "OPD DR VISITS-SELF/FAMILY AMT-FAC 15";
label variable OPVMCR15 "OPD DR VISITS-MEDICARE AMT-FAC 15";
label variable OPVMCD15 "OPD DR VISITS-MEDICAID AMT-FAC 15";
label variable OPVPRV15 "OPD DR VISITS-PRIV INS AMT-FAC 15";
label variable OPVVA15 "OPD DR VISITS-VA/CHAMPVA AMT-FAC 15";
label variable OPVTRI15 "OPD DR VISITS-TRICARE AMT-FAC 15";
label variable OPVOFD15 "OPD DR VISITS-OTHER FED AMT-FAC 15";
label variable OPVSTL15 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 15";
label variable OPVWCP15 "OPD DR VISITS-WORKERS COMP AMT-FAC 15";
label variable OPVOPR15 "OPD DR VISITS - OTH PRIVATE AMT-FAC 15";
label variable OPVOPU15 "OPD DR VISITS-OTH PUBLIC AMT-FAC 15";
label variable OPVOSR15 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 15";
label variable OPVPTR15 "OPD DR VISITS - PRV & TRI AMT-FAC 15";
label variable OPVOTH15 "OPD DR VISITS - OTH COMBINED AMT-FAC 15";
label variable OPSEXP15 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 15";
label variable OPSTCH15 "OPD PHYSICIAN VISIT CHARGES - DR 15";
label variable OPSSLF15 "OPD DR VISITS-SELF/FAMILY AMT-DR 15";
label variable OPSMCR15 "OPD DR VISITS-MEDICARE AMT-DR 15";
label variable OPSMCD15 "OPD DR VISITS-MEDICAID AMT-DR 15";
label variable OPSPRV15 "OPD DR VISITS-PRIV INS AMT-DR 15";
label variable OPSVA15 "OPD DR VISITS-VA/CHAMPVA AMT-DR 15";
label variable OPSTRI15 "OPD DR VISITS-TRICARE AMT-DR 15";
label variable OPSOFD15 "OPD DR VISITS-OTHER FED AMT-DR 15";
label variable OPSSTL15 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 15";
label variable OPSWCP15 "OPD DR VISITS-WORKERS COMP AMT-DR 15";
label variable OPSOPR15 "OPD DR VISITS - OTH PRIVATE AMT-DR 15";
label variable OPSOPU15 "OPD DR VISITS-OTH PUBLIC AMT-DR 15";
label variable OPSOSR15 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 15";
label variable OPSPTR15 "OPD DR VISITS - PRV & TRI AMT-DR 15";
label variable OPSOTH15 "OPD DR VISITS -OTH COMBINED AMT-DR 15";
label variable OPOTHV15 "# OUTPATIENT DEPT NON-DR VISITS 15";
label variable OPOTCH15 "OPD NON-PHYS VISIT CHARGES - FAC 15";
label variable OPOEXP15 "TOTAL OUTPATIENT NON-DR - FAC EXP 15";
label variable OPOSLF15 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 15";
label variable OPOMCR15 "OPD NON-DR VISITS-MEDICARE AMT-FAC 15";
label variable OPOMCD15 "OPD NON-DR VISITS-MEDICAID AMT-FAC 15";
label variable OPOPRV15 "OPD NON-DR VISITS-PRIV INS AMT-FAC 15";
label variable OPOVA15 "OPD NON-DR VISITS-VA/CHAMPVA AMT-FAC 15";
label variable OPOTRI15 "OPD NON-DR VISITS-TRICARE AMT-FAC 15";
label variable OPOOFD15 "OPD NON-DR VISITS-OTHER FED AMT-FAC 15";
label variable OPOSTL15 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 15";
label variable OPOWCP15 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 15";
label variable OPOOPR15 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 15";
label variable OPOOPU15 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 15";
label variable OPOOSR15 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 15";
label variable OPOPTR15 "OPD NON-DR VISITS - PRV & TRI AMT-FAC 15";
label variable OPOOTH15 "OPD NON-DR VISITS-OTH COMBINED AM-FAC 15";
label variable OPPEXP15 "TOTAL OUTPATIENT NON-DR - DR EXP 15";
label variable OPPTCH15 "OPD NON-PHYS VISIT CHARGES - DR 15";
label variable OPPSLF15 "OPD NON-DR VISITS-SELF/FAM AMT-DR 15";
label variable OPPMCR15 "OPD NON-DR VISITS-MEDICARE AMT-DR 15";
label variable OPPMCD15 "OPD NON-DR VISITS-MEDICAID AMT-DR 15";
label variable OPPPRV15 "OPD NON-DR VISITS-PRIV INS AMT-DR 15";
label variable OPPVA15 "OPD NON-DR VISITS-VA/CHAMPVA AMT-DR 15";
label variable OPPTRI15 "OPD NON-DR VISITS-TRICARE AMT-DR 15";
label variable OPPOFD15 "OPD NON-DR VISITS-OTHER FED AMT-DR 15";
label variable OPPSTL15 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 15";
label variable OPPWCP15 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 15";
label variable OPPOPR15 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 15";
label variable OPPOPU15 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 15";
label variable OPPOSR15 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 15";
label variable OPPPTR15 "OPD NON-DR VISITS - PRV & TRI AMT-DR 15";
label variable OPPOTH15 "OPD NON-DR VISITS-OTH COMBINED AMT-DR 15";
label variable AMCHIR15 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2015";
label variable AMCTCH15 "CHIRO AMBULATORY VISIT CHARGES 15";
label variable AMCEXP15 "TOTL AMBULTRY (OB+OP) CHIRO EXP 15";
label variable AMCSLF15 "CHIRO AMB VISITS - SELF/FAMILY AMT 15";
label variable AMCMCR15 "CHIRO AMB VISITS - MEDICARE AMT 15";
label variable AMCMCD15 "CHIRO AMB VISITS - MEDICAID AMT 15";
label variable AMCPRV15 "CHIRO AMB VISITS - PRIVATE INS AMT 15";
label variable AMCVA15 "CHIRO AMB VISITS - VA/CHAMPVA AMT 15";
label variable AMCTRI15 "CHIRO AMB VISITS-TRICARE AMT 15";
label variable AMCOFD15 "CHIRO AMB VISITS - OTHER FEDERAL AMT 15";
label variable AMCSTL15 "CHIRO AMB VISITS - OTH ST/LOCAL AMT 15";
label variable AMCWCP15 "CHIRO AMB VISITS-WORKERS COMP AMT 15";
label variable AMCOPR15 "CHIRO AMB VISITS - OTH PRIVATE AMT 15";
label variable AMCOPU15 "CHIRO AMB VISITS - OTH PUBLIC AMT 15";
label variable AMCOSR15 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 15";
label variable AMCPTR15 "CHIRO AMB VISITS -PRV & TRI AMT 15";
label variable AMCOTH15 "CHIRO AMB VISITS - OTH COMBINED AMT 15";
label variable AMNURS15 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 15";
label variable AMNTCH15 "NRS/PRAC AMBULATORY VISIT CHARGES 15";
label variable AMNEXP15 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 15";
label variable AMNSLF15 "NRS/PRAC AMB VSTS - SELF/FAMILY AMT 15";
label variable AMNMCR15 "NRS/PRAC AMB VSTS - MEDICARE AMT 15";
label variable AMNMCD15 "NRS/PRAC AMB VSTS - MEDICAID AMT 15";
label variable AMNPRV15 "NRS/PRAC AMB VSTS - PRIV INS AMT 15";
label variable AMNVA15 "NRS/PRAC AMB VSTS-VA/CHAMPVA AMT 15";
label variable AMNTRI15 "NRS/PRAC AMB VSTS-TRICARE AMT 15";
label variable AMNOFD15 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 15";
label variable AMNSTL15 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 15";
label variable AMNWCP15 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 15";
label variable AMNOPR15 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 15";
label variable AMNOPU15 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 15";
label variable AMNOSR15 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 15";
label variable AMNPTR15 "NRS/PRAC AMB VSTS - PRV & TRI AMT 15";
label variable AMNOTH15 "NRS/PRAC AMB VSTS - OTH COMBINED AMT 15";
label variable AMOPTO15 "# AMB OPTOMETRIST VSTS (OB+OP) 15";
label variable AMETCH15 "OPTOMETRIST AMBULATORY VISIT CHARGES 15";
label variable AMEEXP15 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 15";
label variable AMESLF15 "OPTMTRIST AMB VSTS - SELF/FAMILY AMT 15";
label variable AMEMCR15 "OPTMTRIST AMB VSTS - MEDICARE AMT 15";
label variable AMEMCD15 "OPTMTRIST AMB VSTS - MEDICAID AMT 15";
label variable AMEPRV15 "OPTMTRIST AMB VSTS - PRIVATE INS AMT 15";
label variable AMEVA15 "OPTMTRIST AMB VSTS-VA/CHAMPVA AMT 15";
label variable AMETRI15 "OPTMTRIST AMB VSTS-TRICARE AMT 15";
label variable AMEOFD15 "OPTMTRIST AMB VSTS-OTHER FED AMT 15";
label variable AMESTL15 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 15";
label variable AMEWCP15 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 15";
label variable AMEOPR15 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 15";
label variable AMEOPU15 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 15";
label variable AMEOSR15 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 15";
label variable AMEPTR15 "OPTMTRIST AMB VSTS - PRV & TRI AMT 15";
label variable AMEOTH15 "OPTMTRIST AMB VSTS - OTH COMBINED AMT 15";
label variable AMASST15 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2015";
label variable AMATCH15 "PHYS ASS T AMBULATORY VISIT CHARGES 15";
label variable AMAEXP15 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 15";
label variable AMASLF15 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 15";
label variable AMAMCR15 "PHYS ASS T AMB VSTS-MEDICARE AMT 15";
label variable AMAMCD15 "PHYS ASS T AMB VSTS-MEDICAID AMT 15";
label variable AMAPRV15 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 15";
label variable AMAVA15 "PHYS ASS T AMB VSTS-VA/CHAMPVA AMT 15";
label variable AMATRI15 "PHYS ASS T AMB VSTS-TRICARE AMT 15";
label variable AMAOFD15 "PHYS ASS T AMB VSTS - OTHER FED AMT 15";
label variable AMASTL15 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 15";
label variable AMAWCP15 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 15";
label variable AMAOPR15 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 15";
label variable AMAOPU15 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 15";
label variable AMAOSR15 "P A AMB VSTS - OTH UNCLASS SRCE AMT 15";
label variable AMAPTR15 "PHYS ASS T AMB VSTS - PRV & TRI AMT 15";
label variable AMAOTH15 "PHYS ASS T AMB VSTS-OTH COMBINED AMT 15";
label variable AMTHER15 "# AMB PT/OT THRPY VISITS (OB+OP) 15";
label variable AMTTCH15 "PT/OC AMBULATORY VISIT CHARGES 15";
label variable AMTEXP15 "TOTL AMBULTRY (OB+OP) PT/OT EXP 15";
label variable AMTSLF15 "PT/OT AMB VISITS-SELF/FAMILY AMT 15";
label variable AMTMCR15 "PT/OT AMB VISITS-MEDICARE AMT 15";
label variable AMTMCD15 "PT/OT AMB VISITS-MEDICAID AMT 15";
label variable AMTPRV15 "PT/OT AMB VISITS-PRIVATE INS AMT 15";
label variable AMTVA15 "PT/OT AMB VISITS-VA/CHAMPVA AMT 15";
label variable AMTTRI15 "PT/OT AMB VISITS-TRICARE AMT 15";
label variable AMTOFD15 "PT/OT AMB VISITS - OTHER FED AMT 15";
label variable AMTSTL15 "PT/OT AMB VISITS-OTH ST/LOCL AMT 15";
label variable AMTWCP15 "PT/OT AMB VISITS-WORKERS COMP AMT 15";
label variable AMTOPR15 "PT/OT AMB VISITS - OTH PRIVATE AMT 15";
label variable AMTOPU15 "PT/OT AMB VISITS-OTH PUBLIC AMT 15";
label variable AMTOSR15 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 15";
label variable AMTPTR15 "PT/OT AMB VISITS -PRV & TRI AMT 15";
label variable AMTOTH15 "PT/OT AMB VISITS - OTH COMBINED AMT 15";
label variable AMTOTC15 "# CALLS W/OFFICE & OUPAT DEPTS, 2015";
label variable AMDRC15 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2015";
label variable ERTOT15 "# EMERGENCY ROOM VISITS 15";
label variable ERTTCH15 "ER FACILITY + DR VISIT CHARGES 15";
label variable ERTEXP15 "TOTAL ER FACILITY + DR EXP 15";
label variable ERTSLF15 "ER-SELF/FAMILY AMT-(FAC+DR) 15";
label variable ERTMCR15 "ER-MEDICARE AMT-(FAC+DR) 15";
label variable ERTMCD15 "ER-MEDICAID AMT-(FAC+DR) 15";
label variable ERTPRV15 "ER-PRIV INS AMT-(FAC+DR) 15";
label variable ERTVA15 "ER-VA/CHAMPVA AMT-(FAC+DR) 15";
label variable ERTTRI15 "ER-TRICARE AMT-(FAC+DR) 15";
label variable ERTOFD15 "ER-OTHER FED AMT-(FAC+DR) 15";
label variable ERTSTL15 "ER-OTH ST/LOCAL AMT-(FAC+DR) 15";
label variable ERTWCP15 "ER-WORKERS COMP AMT-(FAC+DR) 15";
label variable ERTOPR15 "ER-OTH PRIVATE AMT-(FAC+DR) 15";
label variable ERTOPU15 "ER-OTH PUBLIC AMT-(FAC+DR) 15";
label variable ERTOSR15 "ER-OTH UNCLASS SRCE AMT-(FAC+DR) 15";
label variable ERTPTR15 "ER-PRV & TRI AMT (FAC+DR) 15";
label variable ERTOTH15 "ER -OTH COMBINED AMT (FAC+DR) 15";
label variable ERFTCH15 "ER FACILITY VISIT CHARGES 15";
label variable ERFEXP15 "TOTAL ER FACILITY EXP 15";
label variable ERFSLF15 "ER-SELF/FAMILY AMT - FAC 15";
label variable ERFMCR15 "ER-MEDICARE AMT - FAC 15";
label variable ERFMCD15 "ER-MEDICAID AMT - FAC 15";
label variable ERFPRV15 "ER-PRIVATE INS AMT - FAC 15";
label variable ERFVA15 "ER-VA/CHAMPVA AMT - FAC 15";
label variable ERFTRI15 "ER-TRICARE AMT - FAC 15";
label variable ERFOFD15 "ER-OTHER FEDERAL AMT - FAC 15";
label variable ERFSTL15 "ER-OTH ST/LOCAL AMT - FAC 15";
label variable ERFWCP15 "ER-WORKERS COMP AMT - FAC 15";
label variable ERFOPR15 "ER-OTHER PRIVATE AMT - FAC 15";
label variable ERFOPU15 "ER-OTHER PUBLIC AMT - FAC 15";
label variable ERFOSR15 "ER-OTH UNCLASS SRCE AMT - FAC 15";
label variable ERFPTR15 "ER-PRV & TRI AMT - FAC 15";
label variable ERFOTH15 "ER-OTH COMBINED AMT - FAC 15";
label variable ERDEXP15 "TOTAL EMERGENCY ROOM DR EXP 15";
label variable ERDTCH15 "ER DOCTOR VISIT CHARGES 15";
label variable ERDSLF15 "ER-SELF/FAMILY AMT - DR 15";
label variable ERDMCR15 "ER-MEDICARE AMT - DR 15";
label variable ERDMCD15 "ER-MEDICAID AMT - DR 15";
label variable ERDPRV15 "ER-PRIVATE INS AMT - DR 15";
label variable ERDVA15 "ER-VA/CHAMPVA AMT - DR 15";
label variable ERDTRI15 "ER-TRICARE AMT - DR 15";
label variable ERDOFD15 "ER-OTHER FED AMT - DR 15";
label variable ERDSTL15 "ER-OTH ST/LOCAL AMT - DR 15";
label variable ERDWCP15 "ER-WORKERS COMP AMT - DR 15";
label variable ERDOPR15 "ER - OTHER PRIVATE AMT - DR 15";
label variable ERDOPU15 "ER - OTHER PUBLIC AMT - DR 15";
label variable ERDOSR15 "ER-OTH UNCLASS SRCE AMT - DR 15";
label variable ERDPTR15 "ER-PRV & TRI AMT - DR 15";
label variable ERDOTH15 "ER-OTH COMBINED AMT - DR 15";
label variable IPZERO15 "# ZERO-NIGHT HOSPITAL STAYS 15";
label variable ZIFTCH15 "ZERO-NITE IP STAY CHARGES - FAC 15";
label variable ZIFEXP15 "TOTAL ZERO-NITE STAYS FAC EXP 15";
label variable ZIFSLF15 "ZERO-NITE IP STAZ-SELF/FAM AMT-FAC 15";
label variable ZIFMCR15 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 15";
label variable ZIFMCD15 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 15";
label variable ZIFPRV15 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 15";
label variable ZIFVA15 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-FAC 15";
label variable ZIFTRI15 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 15";
label variable ZIFOFD15 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 15";
label variable ZIFSTL15 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 15";
label variable ZIFWCP15 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 15";
label variable ZIFOPR15 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 15";
label variable ZIFOPU15 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 15";
label variable ZIFOSR15 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 15";
label variable ZIFPTR15 "ZERO-NITE IP STAZ-PRV & TRI AMT-FAC 15";
label variable ZIFOTH15 "ZERO-NITE IP STAZ-OTH COMBINE AMT-FAC 15";
label variable ZIDEXP15 "TOTAL ZERO-NITE STAZ DR 15";
label variable ZIDTCH15 "ZERO-NITE IP STAY CHARGES - DR 15";
label variable ZIDSLF15 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 15";
label variable ZIDMCR15 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 15";
label variable ZIDMCD15 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 15";
label variable ZIDPRV15 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 15";
label variable ZIDVA15 "ZERO-NITE IP STAZ-VA/CHAMPVA AMT-DR 15";
label variable ZIDTRI15 "ZERO-NITE IP STAZ-TRICARE AMT-DR 15";
label variable ZIDOFD15 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 15";
label variable ZIDSTL15 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 15";
label variable ZIDWCP15 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 15";
label variable ZIDOPR15 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 15";
label variable ZIDOPU15 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 15";
label variable ZIDOSR15 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 15";
label variable ZIDPTR15 "ZERO-NITE IP STAZ-PRV & TRI AMT-DR 15";
label variable ZIDOTH15 "ZERO-NITE IP STAZ-OTH COMBINED AMT-DR 15";
label variable IPDIS15 "# HOSPITAL DISCHARGES, 2015";
label variable IPTEXP15 "TOT HOSP IP FACILITY + DR EXP 15";
label variable IPTTCH15 "IP HOSP STAY CHARGES (FAC+DR) 15";
label variable IPTSLF15 "IP HOSP STAZ-SELF/FAMILY AMT-(FAC+DR) 15";
label variable IPTMCR15 "IP HOSP STAZ-MEDICARE AMT-(FAC+DR) 15";
label variable IPTMCD15 "IP HOSP STAZ-MEDICAID AMT-(FAC+DR) 15";
label variable IPTPRV15 "IP HOSP STAZ-PRIV INS AMT-(FAC+DR) 15";
label variable IPTVA15 "IP HOSP STAZ-VA/CHAMPVA AMT-(FAC+DR) 15";
label variable IPTTRI15 "IP HOSP STAZ-TRICARE AMT-(FAC+DR) 15";
label variable IPTOFD15 "IP HOSP STAZ-OTHER FED AMT-(FAC+DR) 15";
label variable IPTSTL15 "IP HSP STAZ-OTH ST/LOCAL AMT-(FAC+DR) 15";
label variable IPTWCP15 "IP HOSP STAZ-WRKRS COMP AMT-(FAC+DR) 15";
label variable IPTOPR15 "IP HOSP STAZ-OTH PRIVATE AMT-(FAC+DR) 15";
label variable IPTOPU15 "IP HOSP STAZ-OTH PUBLIC AMT-(FAC+DR) 15";
label variable IPTOSR15 "IP HSP STAZ-OTH UNCLS SRC AMT(FAC+DR) 15";
label variable IPTPTR15 "IP HOSP STAZ-PRV & TRI AMT-(FAC+DR) 15";
label variable IPTOTH15 "IP HOSP STAZ-OTH COMBINED AMT(FAC+DR) 15";
label variable IPFEXP15 "TOT HOSP IP FACILITY EXP-INC 0 NITES 15";
label variable IPFTCH15 "IP HOSP STAY CHARGES - FAC 15";
label variable IPFSLF15 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 15";
label variable IPFMCR15 "IP HOSP STAZ-MEDICARE AMT-FAC 15";
label variable IPFMCD15 "IP HOSP STAZ-MEDICAID AMT-FAC 15";
label variable IPFPRV15 "IP HOSP STAZ-PRIV INS AMT-FAC 15";
label variable IPFVA15 "IP HOSP STAZ-VA/CHAMPVA AMT-FAC 15";
label variable IPFTRI15 "IP HOSP STAZ-TRICARE AMT-FAC 15";
label variable IPFOFD15 "IP HOSP STAZ-OTHER FED AMT-FAC 15";
label variable IPFSTL15 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 15";
label variable IPFWCP15 "IP HOSP STAZ-WORKERS COMP AMT-FAC 15";
label variable IPFOPR15 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 15";
label variable IPFOPU15 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 15";
label variable IPFOSR15 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 15";
label variable IPFPTR15 "IP HOSP STAZ-PRV & TRI AMT-FAC 15";
label variable IPFOTH15 "IP HOSP STAZ-OTH COMBINED AMT-FAC 15";
label variable IPDEXP15 "TOTL HOSP STAZ DR EXP 15";
label variable IPDTCH15 "IP HOSP STAY CHARGES - DR 15";
label variable IPDSLF15 "IP HOSP STAZ-SELF/FAMILY AMT-DR 15";
label variable IPDMCR15 "IP HOSP STAZ-MEDICARE AMT- DR 15";
label variable IPDMCD15 "IP HOSP STAZ-MEDICAID AMT-DR 15";
label variable IPDPRV15 "IP HOSP STAZ-PRIV INS AMT-DR 15";
label variable IPDVA15 "IP HOSP STAZ-VA/CHAMPVA AMT-DR 15";
label variable IPDTRI15 "IP HOSP STAZ-TRICARE AMT-DR 15";
label variable IPDOFD15 "IP HOSP STAZ-OTHER FED AMT-DR 15";
label variable IPDSTL15 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 15";
label variable IPDWCP15 "IP HOSP STAZ-WORKERS COMP AMT-DR 15";
label variable IPDOPR15 "IP HOSP STAZ - OTH PRIVATE AMT-DR 15";
label variable IPDOPU15 "IP HOSP STAZ - OTH PUBLIC AMT-DR 15";
label variable IPDOSR15 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 15";
label variable IPDPTR15 "IP HOSP STAZ-PRV & TRI AMT-DR 15";
label variable IPDOTH15 "IP HOSP STAZ-OTH COMBINED AMT-DR 15";
label variable IPNGTD15 "# NIGHTS IN HOSP FOR DISCHARGES, 2015";
label variable DVTOT15 "# DENTAL CARE VISITS 15";
label variable DVTTCH15 "TOTAL DENTAL CARE VISIT CHARGES 15";
label variable DVTEXP15 "TOTAL DENTAL CARE EXP 15";
label variable DVTSLF15 "ALL DENTAL CARE - SELF/FAMILY AMT 15";
label variable DVTMCR15 "ALL DENTAL CARE - MEDICARE AMT 15";
label variable DVTMCD15 "ALL DENTAL CARE - MEDICAID AMT 15";
label variable DVTPRV15 "ALL DENTAL CARE - PRIVATE INS AMT 15";
label variable DVTVA15 "ALL DENTAL CARE - VA/CHAMPVA AMT 15";
label variable DVTTRI15 "ALL DENTAL CARE - TRICARE AMT 15";
label variable DVTOFD15 "ALL DENTAL CARE - OTHER FEDRL AMT 15";
label variable DVTSTL15 "ALL DENTAL CARE - OTH ST/LOCAL AMT 15";
label variable DVTWCP15 "ALL DENTAL CARE - WORKERS COMP AMT 15";
label variable DVTOPR15 "ALL DENTAL CARE - OTH PRIVATE AMT 15";
label variable DVTOPU15 "ALL DENTAL CARE - OTH PUBLIC AMT 15";
label variable DVTOSR15 "ALL DENT CARE-OT UNCLASS SRCE AMT 15";
label variable DVTPTR15 "ALL DENTAL CARE - PRV & TRI AMT 15";
label variable DVTOTH15 "ALL DENTAL CARE - OTH COMBINED AMT 15";
label variable DVGEN15 "# GENERAL DENTIST VISITS 15";
label variable DVGTCH15 "GENERAL DENTAL CARE VISIT CHARGES 15";
label variable DVGEXP15 "TOTAL GENERAL DENTIST EXP 15";
label variable DVGSLF15 "GNRL DENTAL VISITS - SELF/FAM AMT 15";
label variable DVGMCR15 "GNRL DENTAL VISITS - MEDICARE AMT 15";
label variable DVGMCD15 "GNRL DENTAL VISITS - MEDICAID AMT 15";
label variable DVGPRV15 "GNRL DENTAL VISITS - PRIVATE INS AMT 15";
label variable DVGVA15 "GNRL DENTAL VISITS - VA/CHAMPVA AMT 15";
label variable DVGTRI15 "GNRL DENTAL VISITS-TRICARE AMT 15";
label variable DVGOFD15 "GNRL DENTAL VISITS - OTHER FED AMT 15";
label variable DVGSTL15 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 15";
label variable DVGWCP15 "GNRL DENTAL VISITS - WORKERS COMP AMT 15";
label variable DVGOPR15 "GNRL DENTAL VISITS - OTH PRIVATE AMT 15";
label variable DVGOPU15 "GNRL DENTAL VISITS - OTH PUBLIC AMT 15";
label variable DVGOSR15 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 15";
label variable DVGPTR15 "GNRL DENTAL VISITS - PRV & TRI AMT 15";
label variable DVGOTH15 "GNRL DENTAL VISITS - OTH COMBINED AMT 15";
label variable DVORTH15 "# ORTHODONTIST VISITS 15";
label variable DVOTCH15 "ORTHODONTIST VISIT CHARGES 15";
label variable DVOEXP15 "TOTAL ORTHODONTIST EXP 15";
label variable DVOSLF15 "ORTHODONTIST VISITS - SELF/FAMILY AMT 15";
label variable DVOMCR15 "ORTHODONTIST VISITS - MEDICARE AMT 15";
label variable DVOMCD15 "ORTHODONTIST VISITS - MEDICAID AMT 15";
label variable DVOPRV15 "ORTHODONTIST VISITS - PRIVATE INS AMT 15";
label variable DVOVA15 "ORTHODONTIST VISITS-VA/CHAMPVA AMT 15";
label variable DVOTRI15 "ORTHODONTIST VISITS-TRICARE AMT 15";
label variable DVOOFD15 "ORTHODONTIST VISITS-OTHR FED AMT 15";
label variable DVOSTL15 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 15";
label variable DVOWCP15 "ORTHODONTIST VISITS-WORKERS COMP AMT 15";
label variable DVOOPR15 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 15";
label variable DVOOPU15 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 15";
label variable DVOOSR15 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 15";
label variable DVOPTR15 "ORTHODONTIST VISITS - PRV & TRI AMT 15";
label variable DVOOTH15 "ORTHODONTIST VISITS-OTH COMBINED AMT 15";
label variable HHTOTD15 "# HOME HEALTH PROVIDER DAYS, 2015";
label variable HHAGD15 "# AGENCY HOME HEALTH PROVIDER DAYS 15";
label variable HHATCH15 "HOME HEALTH AGENCY VISIT CHARGES 15";
label variable HHAEXP15 "TOTAL HOME HEALTH AGENCY EXP 15";
label variable HHASLF15 "HOME HLTH AGENCY - SELF/FAMILY AMT 15";
label variable HHAMCR15 "HOME HLTH AGENCY - MEDICARE AMT 15";
label variable HHAMCD15 "HOME HLTH AGENCY - MEDICAID AMT 15";
label variable HHAPRV15 "HOME HLTH AGENCY - PRIVATE INS AMT 15";
label variable HHAVA15 "HOME HLTH AGENCY-VA/CHAMPVA AMT 15";
label variable HHATRI15 "HOME HLTH AGENCY-TRICARE AMT 15";
label variable HHAOFD15 "HOME HLTH AGENCY - OTHER FED AMT 15";
label variable HHASTL15 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 15";
label variable HHAWCP15 "HOME HLTH AGENCY - WORKERS COMP AMT 15";
label variable HHAOPR15 "HOME HLTH AGENCY - OTH PRIVATE AMT 15";
label variable HHAOPU15 "HOME HLTH AGENCY - OTH PUBLIC AMT 15";
label variable HHAOSR15 "H HLTH AGENCY - OT UNCLASS SRCE AMT 15";
label variable HHAPTR15 "HOME HLTH AGENCY - PRV & TRI AMT 15";
label variable HHAOTH15 "HOME HLTH AGENCY - OTH COMBINED AMT 15";
label variable HHINDD15 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 15";
label variable HHNTCH15 "HOME HEALTH NON-AGENCY VISIT CHARGES 15";
label variable HHNEXP15 "TOTAL HOME HEALTH NON-AGNCY EXP 15";
label variable HHNSLF15 "HOME HLTH NON-AGNCY - SELF/FAM AMT 15";
label variable HHNMCD15 "HOME HLTH NON-AGNCY - MEDICAID AMT 15";
label variable HHNMCR15 "HOME HLTH NON-AGNCY - MEDICARE AMT 15";
label variable HHNPRV15 "HOME HLTH NON-AGNCY - PRIV INS AMT 15";
label variable HHNVA15 "HOME HLTH NON-AGNCY-VA/CHAMPVA AMT 15";
label variable HHNTRI15 "HOME HLTH NON-AGNCY-TRICARE AMT 15";
label variable HHNOFD15 "HOME HLTH NON-AGNCY-OTHR FED AMT 15";
label variable HHNSTL15 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 15";
label variable HHNWCP15 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 15";
label variable HHNOPR15 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 15";
label variable HHNOPU15 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 15";
label variable HHNOSR15 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 15";
label variable HHNPTR15 "HOME HLTH NON-AGNCY - PRV & TRI AMT 15";
label variable HHNOTH15 "HOME HLTH NON-AGNCY-OTH COMBINED AMT 15";
label variable HHINFD15 "# INFORMAL HOME HEALTH PROVIDER DAYS 15";
label variable VISEXP15 "TOTAL GLASSES/CONTACT LENS EXP 15";
label variable VISTCH15 "GLASSES/CONTACT LENSES CHARGES 15";
label variable VISSLF15 "GLASSES/CNTCT LENSES -SELF/FAM AMT 15";
label variable VISMCR15 "GLASSES/CNTCT LENSES-MEDICARE AMT 15";
label variable VISMCD15 "GLASSES/CNTCT LENSES-MEDICAID AMT 15";
label variable VISPRV15 "GLASSES/CNTCT LENSES-PRIV INS AMT 15";
label variable VISVA15 "GLASSES/CNTCT LENSES-VA/CHAMPVA AMT 15";
label variable VISTRI15 "GLASSES/LENSES-TRICARE AMT 15";
label variable VISOFD15 "GLASSES/CNTCT LENSES-OTHR FED AMT 15";
label variable VISSTL15 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 15";
label variable VISWCP15 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 15";
label variable VISOPR15 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 15";
label variable VISOPU15 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 15";
label variable VISOSR15 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 15";
label variable VISPTR15 "GLASSES/CNTCT LENSES-PRV & TRI AMT 15";
label variable VISOTH15 "GLASSES/CNTCT LENSES-OTH COMBINED AMT 15";
label variable OTHTCH15 "OTHER EQUP/SUPPLIES CHARGES 15";
label variable OTHEXP15 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 15";
label variable OTHSLF15 "OTHER EQUP/SUPPLIES-SELF/FAM AMT 15";
label variable OTHMCR15 "OTHER EQUP/SUPPLIES-MEDICARE AMT 15";
label variable OTHMCD15 "OTHER EQUP/SUPPLIES-MEDICAID AMT 15";
label variable OTHPRV15 "OTHER EQUP/SUPPLIES-PRIV INS AMT 15";
label variable OTHVA15 "OTHER EQUP/SUPPLY-VA/CHAMPVA AMT 15";
label variable OTHTRI15 "OTHER EQUP/SUPPLY-TRICARE AMT 15";
label variable OTHOFD15 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 15";
label variable OTHSTL15 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 15";
label variable OTHWCP15 "OTHER EQUP/SUPPLY - WORKERS COMP AMT 15";
label variable OTHOPR15 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 15";
label variable OTHOPU15 "OTHER EQUP/SUPPLY - OTH PUBLIC AMT 15";
label variable OTHOSR15 "OTH EQUP/SUPLY - OT UNCLASS SRCE AMT 15";
label variable OTHPTR15 "OTHER EQUP/SUPPLY - PRV & TRI AMT 15";
label variable OTHOTH15 "OTHER EQUP/SUPPLY - OTH COMBINED AMT 15";
label variable RXTOT15 "# PRESC MEDS INCL REFILLS 15";
label variable RXEXP15 "TOTAL RX-EXP 15";
label variable RXSLF15 "TOTAL RX-SELF/FAMILY AMT 15";
label variable RXMCR15 "TOTAL RX-MEDICARE AMT 15";
label variable RXMCD15 "TOTAL RX-MEDICAID AMT 15";
label variable RXPRV15 "TOTAL RX-PRIVATE INS AMT 15";
label variable RXVA15 "TOTAL RX-VA/CHAMPVA AMT 15";
label variable RXTRI15 "TOTAL RX-TRICARE AMT 15";
label variable RXOFD15 "TOTAL RX-OTHER FED AMT 15";
label variable RXSTL15 "TOTAL RX-OTHER ST/LOCAL AMT 15";
label variable RXWCP15 "TOTAL RX-WORKERS COMP AMT 15";
label variable RXOPR15 "TOTAL RX-OTH PRIVATE AMT 15";
label variable RXOPU15 "TOTAL RX-OTH PUBLIC AMT 15";
label variable RXOSR15 "TOT RX-OTH UNCLASS SRCE AMT 15";
label variable RXPTR15 "TOTAL RX-PRV & TRI AMT 15";
label variable RXOTH15 "TOTAL RX-OTH COMBINED AMT 15";
label variable PERWT15F "FINAL PERSON WEIGHT, 2015";
label variable FAMWT15F "FINAL FAMILY WEIGHT, 2015";
label variable FAMWT15C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/15";
label variable SAQWT15F "FINAL SAQ PERSON WEIGHT, 2015";
label variable DIABW15F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2015";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2015";


*DEFINE VALUE LABELS FOR REPORTS;
label define H1810001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1810002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1810003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1810004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1810005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1810008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1810009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1810010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1810013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1810014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1810015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1810017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1810024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1810027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1810028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1810031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1810032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1810034X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H1810035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1810039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1810040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1810042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1810043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H1810044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1810045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H1810046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1810047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF ADMINISTERED"
         10 "10 NIECE/NEPHEW"
         100 "100 INTERVIEWER ADMINISTERED"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD (BLGICAL/ADPT/INLW/STEP/FSTER)"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 GRANDCHILD"
         6 "6 PARENT (BLGICAL/ADPT/INLW/STEP/FSTER)"
         7 "7 SIBLING (BLGICAL/ADPT/INLW/STEP/FSTER)"
         8 "8 GRANDPARENT"
         9 "9 AUNT/UNCLE"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1810049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1810050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1810052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1810053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1810056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1810058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1810061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1810062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H1810063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1810064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810066X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1810067X
         0 "0.00"
         102 "$1 - $102" ;

label define H1810068X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810069X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810070X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810071X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 RHEUMATOID ARTHRITIS"
         2 "2 OSTEOARTHRITIS"
         3 "3 NOT SPECIFIED" ;

label define H1810074X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810077X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810078X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810079X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810081X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810082X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810084X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810085X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810086X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810088X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1810089X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H1810090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H1810091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1810092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1810093X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1810094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2014 "2014 YEAR"
         2015 "2015 YEAR" ;

label define H1810095X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2015 "2015 YEAR" ;

label define H1810096X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2015 "2015 YEAR"
         2016 "2016 YEAR" ;

label define H1810097X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1810098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1810099X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810101X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810102X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810103X
         -1 "-1 INAPPLICABLE, THOSE WHO ARE DEC/INSTD"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1810105X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1810107X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1810108X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1810109X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1810110X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1810111X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1810112X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1810113X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1810114X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1810115X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1810116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810118X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810119X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810120X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810121X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810122X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810125X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810126X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810129X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810130X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1810131X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810132X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810133X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810135X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810136X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810137X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1810138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810142X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1810143X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1810144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1810145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810150X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1810151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810154X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810155X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1810158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810173X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1810176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1810177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1810178X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810179X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810180X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810181X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1810182X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1810183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810186X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H1810187X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1810188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1810189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H1810195X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810196X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810197X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810198X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1810199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810207X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1810209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1810210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H1810211X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1810212X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1810213X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1810214X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1810215X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1810218X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810219X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1810222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1810223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810224X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810225X
         -1 "-1 INAPPLICABLE"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H1810226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H1810227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE A1C BLOOD TEST" ;

label define H1810228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810234X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810235X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT CONFIDENT AT ALL"
         2 "2 SOMEWHAT CONFIDENT"
         3 "3 CONFIDENT"
         4 "4 VERY CONFIDENT" ;

label define H1810237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810248X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810249X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8  DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810256X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810261X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810262X
         0 "0.00"
         95 "$1 - $95" ;

label define H1810263X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810264X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810265X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810266X
         -1 "-1 INAPPLICABLE OR UNDER 5"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN/EQUAL TO 8TH GRADE"
         13 "13 GED OR HS GRAD"
         14 "14 BEYOND HS,COLLEGE(NO 4YR DEG),ASSOC DEG"
         15 "15 4-YEAR COLLEGE DEGREE, BACHELOR'S DEGREE"
         16 "16 MASTER'S, DOCTORATE, OR PROFESSIONAL DEG"
         2 "2 9 - 12TH GRADE, NO HS DIPLOMA OR GED" ;

label define H1810267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H1810268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN/EQUAL TO 8TH GRADE"
         10 "10 CHILD UNDER 5 YEARS OLD"
         2 "2 9-12TH GRADE, NO HIGH SCHOOL DIPLOMA"
         3 "3 GED OR EQUIVALENT"
         4 "4 HIGH SCHOOL DIPLOMA"
         5 "5 SOME COLLEGE, NO DEGREE"
         6 "6 ASSOC DEG: OCCUPATIONAL,TECH,VOCATIONAL"
         7 "7 ASSOCIATE DEGREE: ACADEMIC PROGRAM"
         8 "8 BACHELOR'S DEGREE (BA,AB,BS,BBA)"
         9 "9 MASTER'S, PROFESSIONAL, DOCTORAL DEGREE" ;

label define H1810269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1810270X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1810271X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1810272X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1810273X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1810274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H1810277X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         34 "34 NOT EMPLOYED DURING RD 3/1" ;

label define H1810278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H1810279X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         34 "34 NOT EMPLOYED DURING RD 4/2" ;

label define H1810280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H1810281X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         34 "34 NOT EMPLOYED DURING RD 5/3" ;

label define H1810282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1810283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1810284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1810285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1810286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2014 "2014 YEAR"
         2015 "2015 YEAR" ;

label define H1810287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2014 "2014 YEAR"
         2015 "2015 YEAR" ;

label define H1810288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2015 "2015 YEAR" ;

label define H1810289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2015 "2015 YEAR"
         2016 "2016 YEAR" ;

label define H1810290X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810293X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810295X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1810296X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1810297X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1810298X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1810299X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1810300X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810301X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H1810302X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H1810303X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1810304X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H1810305X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1810306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1810307X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810308X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810309X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H1810310X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810311X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810312X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1810313X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1810314X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1810315X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1810316X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1810317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810319X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1810320X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810321X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810322X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810323X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810324X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810325X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810326X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810327X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810328X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810329X
         0 "0.00"
         225 "$1 - $225" ;

label define H1810330X
         0 "0.00"
         24 "$1 - $24" ;

label define H1810331X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810332X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810333X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810334X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H1810335X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H1810336X
         -1 "-1 INAPPLICABLE"
         1 "1 MEXICAN/MEX AMER/CHICANO-NO OTHER HISP"
         2 "2 PUERTO RICAN -NO OTHER HISP REPORTED"
         3 "3 CUBAN/CUBAN AMERICAN -NO OTHER HISP RPTD"
         4 "4 DOMINICAN -NO OTHER HISP REPORTED"
         5 "5 CENTRAL OR SOUTH AMERICAN -NO OTHER HISP"
         6 "6 OTH LAT AM/HISP/LATINO/SPNSH ORGN-NO OTH"
         8 "8 MULTIPLE HISPANIC GROUPS REPORTED"
         9 "9 NON-HISPANIC" ;

label define H1810337X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1810338X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1810339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1810340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1810341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810342X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810343X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810344X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810345X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810346X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810347X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810348X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810349X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810350X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810351X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810352X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810353X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810354X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810355X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810356X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810357X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810358X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810359X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810360X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810361X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810362X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810363X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810364X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810365X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810366X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810367X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810368X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810369X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810370X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810371X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810372X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810373X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810374X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810375X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810376X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810377X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810378X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810379X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810380X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810381X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810382X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810383X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810384X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810385X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810386X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810389X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810390X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810391X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810392X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810393X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810394X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810395X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810396X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810397X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810398X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810399X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810400X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810401X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810402X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810403X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810405X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810408X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810409X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810411X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810412X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810413X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810414X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810415X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810416X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810417X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810418X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810419X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810420X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810421X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810422X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810423X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810424X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810425X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810426X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810427X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810428X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1810429X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1810430X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1810431X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE" ;

label define H1810432X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $80.00"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810433X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE" ;

label define H1810434X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $80.00"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810435X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE" ;

label define H1810436X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $80.00"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810437X
         0 "0 NO"
         1 "1 YES" ;

label define H1810438X
         0 "0 NO"
         1 "1 YES" ;

label define H1810439X
         0 "0 NO"
         1 "1 YES" ;

label define H1810440X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810441X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810442X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810443X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY WELL"
         2 "2 WELL"
         3 "3 NOT WELL"
         4 "4 NOT AT ALL"
         5 "5 UNDER 5 IN ROUND 1 AND OTHLANG=1, INAPP" ;

label define H1810444X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810445X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810446X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810447X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1810448X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1810449X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1810450X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1810451X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1810452X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1810453X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810454X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810455X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810456X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810457X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810458X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810459X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810460X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810461X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810462X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810463X
         1 "1 IN-SCOPE ON 12/31/2015"
         2 "2 NOT IN-SCOPE ON 12/31/2015" ;

label define H1810464X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/15"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1810465X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/15"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1810466X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/15"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1810467X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/15"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H1810468X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2015"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2015" ;

label define H1810469X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H1810470X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810471X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810472X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810473X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810474X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810475X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810476X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810477X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810478X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810479X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810480X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810481X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810483X
         -1 "-1 INAPPLICABLE"
         1 "1 <65 ANY PRIVATE"
         2 "2 <65 PUBLIC ONLY"
         3 "3 <65 UNINSURED"
         4 "4 65+ EDITED MEDICARE ONLY"
         5 "5 65+ EDITED MEDICARE AND PRIVATE"
         6 "6 65+ EDITED MEDICARE AND OTH PUB ONLY"
         7 "7 65+ UNINSURED"
         8 "8 65+ NO MEDICARE AND ANY PUBLIC/PRIVATE" ;

label define H1810484X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1810485X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H1810486X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810487X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810488X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1810489X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1810490X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1810491X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1810492X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810493X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1810494X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1810495X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1810496X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810497X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810498X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810499X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810500X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810501X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H1810502X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1810503X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810504X
         -1 "-1 INAPPLICABLE, THOSE WHO JOIN AFTER RND 1"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPANISH"
         2 "2 ANOTHER LANGUAGE" ;

label define H1810505X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810506X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H1810507X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H1810508X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H1810509X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810510X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1810511X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H1810512X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1810513X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1810514X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1810515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810541X
         1 "1 YES"
         2 "2 NO" ;

label define H1810542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810544X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1810545X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1810546X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1810547X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810548X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810549X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810550X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810551X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810552X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810553X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810554X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810555X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1810556X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1810557X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1810558X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810559X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810560X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810561X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810562X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810563X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810564X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810565X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810566X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810567X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810568X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810569X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810570X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810571X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810572X
         1 "1 YES"
         2 "2 NO" ;

label define H1810573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810574X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810575X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810577X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810578X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810580X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810582X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810583X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810584X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810585X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810586X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810588X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810589X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1810590X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1810591X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H1810592X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1810593X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1810594X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1810595X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1810596X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1810597X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1810598X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1810599X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1810600X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1810601X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810602X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810603X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810604X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1810605X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810606X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1810607X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1810608X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810609X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1810610X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810611X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810612X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810613X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1810614X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1810615X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810616X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1810617X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1810618X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1810619X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1810620X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810621X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810622X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810623X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810624X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810625X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810626X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810627X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1810628X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1810629X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1810630X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810631X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810632X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1810633X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810634X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810635X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$80.00"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810636X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$80.00"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810637X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$80.00"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810638X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810639X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810640X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810641X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810642X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810643X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810644X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H1810645X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810646X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810647X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810648X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810649X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810650X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810651X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1810652X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1810653X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1810654X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810655X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810656X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810657X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810658X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810659X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810660X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810661X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810662X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1810663X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1810664X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1810665X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1810666X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1810667X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1810668X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810669X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810670X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810671X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810672X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810673X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810674X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810675X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810676X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810677X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810678X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810679X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810680X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810681X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810682X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810683X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810684X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810685X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810686X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810687X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810688X
         1 "1 YES"
         2 "2 NO" ;

label define H1810689X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810690X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810691X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810692X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810693X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810694X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810695X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810696X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810697X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810698X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810699X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810700X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810701X
         1 "1 YES"
         2 "2 NO" ;

label define H1810702X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810703X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810704X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810705X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810706X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810707X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810708X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810709X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810710X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810711X
         0 "0.00"
         33 "$1 - $33" ;

label define H1810712X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810713X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810714X
         0 "0.00"
         33 "$1 - $33" ;

label define H1810715X
         0 "0.00"
         33 "$1 - $33" ;

label define H1810716X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810717X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810718X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1810719X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810720X
         -1 "-1 INAPPLICABLE, THOSE WHO JOIN AFTER RND 1"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810721X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1810722X
         0 "0.00"
         15 "$1 - $15" ;

label define H1810723X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810724X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810726X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810727X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810728X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810730X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810731X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810732X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810733X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810740X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810741X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810742X
         19 "19 PANEL 19"
         20 "20 PANEL 20" ;

label define H1810743X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1810744X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810745X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810746X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810747X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810748X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810749X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810750X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810751X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810752X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810753X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810754X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810755X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810756X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810757X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810758X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810759X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810760X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810761X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810762X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810763X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810764X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810765X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810766X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810767X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810768X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810769X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810770X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810771X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810772X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810773X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810774X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810775X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810776X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810777X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1810778X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810779X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1810780X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1810781X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810782X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810783X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H1810784X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810785X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810786X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810787X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1810788X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810789X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810790X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810791X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1810792X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1810793X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1810794X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810795X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810796X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810797X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810798X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1810799X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810800X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810801X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810802X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810803X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810804X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810805X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810806X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810807X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810808X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810809X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810810X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810811X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810812X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810813X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810814X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810815X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810816X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810817X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810818X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810819X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810820X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810821X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810822X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810823X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810824X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810825X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810826X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810827X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810828X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810829X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810830X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810831X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810832X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810833X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810834X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810835X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H1810836X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810837X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810838X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810839X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810840X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810841X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810842X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810843X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810844X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810845X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810846X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810847X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810848X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810849X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810850X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810851X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810852X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810853X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810854X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810855X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810856X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810857X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810858X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810859X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810860X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810861X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810862X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810863X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810864X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810865X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810866X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810867X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810868X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810869X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810870X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810871X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810872X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810873X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810874X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810875X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810876X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810877X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810878X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810879X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810880X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810881X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810882X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810883X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810884X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810885X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810886X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H1810887X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1810888X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1810889X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1810890X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1810891X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810892X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810893X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810894X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810895X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810896X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810897X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810898X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810899X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810900X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810901X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810902X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810903X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810904X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810905X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810906X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810907X
         1 "1 YES"
         2 "2 NO" ;

label define H1810908X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1810909X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1810910X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1810911X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810912X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810913X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810914X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810915X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810916X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810917X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810918X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810919X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810920X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810921X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810924X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1810925X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1810926X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1810927X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1810928X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810931X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810933X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810934X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810935X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810936X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810937X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810938X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810939X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810940X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1810941X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810942X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810943X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810944X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810945X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810946X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810947X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810948X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810949X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810950X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810951X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810952X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810953X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1810954X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1810955X
         -1 "-1 INAPPLICABLE"
         1 "1 HISPANIC"
         2 "2 NON-HISPANIC WHITE ONLY"
         3 "3 NON-HISPANIC BLACK ONLY"
         4 "4 NON-HISPANIC ASIAN ONLY"
         5 "5 NON-HISPANIC OTHER RACE OR MULTIPLE RACE" ;

label define H1810956X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H1810957X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         10 "10 OTH ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         12 "12 MULTIPLE RACES REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN INDIAN - NO OTHER RACE REPORTED"
         5 "5 CHINESE - NO OTHER RACE REPORTED"
         6 "6 FILIPINO - NO OTHER RACE REPORTED" ;

label define H1810958X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1810959X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1810960X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1810961X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810962X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1810963X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1810964X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1810965X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/INLAW/STEP/FOSTR"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         8 "8 SIBLING (BIOLGCL/ADOPT/INLAW/STEP/FOSTR)"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H1810966X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1810967X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1810968X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1810969X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1810970X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1810971X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1810972X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1810973X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1810974X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1810975X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810976X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810977X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810978X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H1810979X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1810980X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1810981X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1810982X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810983X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810984X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1810985X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1810986X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1810987X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1810988X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1810989X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1810990X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1810991X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1810992X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1810993X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810994X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1810995X
         0 "0 NOT ELIGIBLE FOR SAQ"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H1810996X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1810997X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810998X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1810999X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1811000X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811002X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H1811004X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811006X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811007X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1811009X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H1811010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PART OF A ROUTINE EXAM"
         2 "2 BECAUSE OF A PROBLEM"
         3 "3 SOME OTHER REASON" ;

label define H1811011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 WITHIN PAST 10 YEARS"
         6 "6 MORE THAN 10 YEARS"
         7 "7 NEVER" ;

label define H1811012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1811013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811014X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811015X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811016X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811017X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811018X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811021X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1811022X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1811023X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1811024X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YEARS OLD" ;

label define H1811025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1811026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1811027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1811028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1811029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1811030X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1811031X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1811032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1811033X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1811034X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1811035X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811036X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811037X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811038X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811039X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811040X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811041X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811042X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811043X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811044X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811045X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811046X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811047X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811048X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811049X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811050X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1811052X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1811053X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1811054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1811055X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1811056X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1811057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1811058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1811059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1811061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1811062X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811063X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811064X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811065X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811066X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1811067X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811068X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG FORM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H1811069X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1811070X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1811071X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1811072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H1811074X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1811076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811077X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811078X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811079X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811080X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811081X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811082X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811083X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811084X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811085X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811086X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811087X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811088X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811089X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811090X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811091X
         1 "1 YES"
         2 "2 NO" ;

label define H1811092X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811093X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811094X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811095X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811096X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811097X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811098X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811099X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811100X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811101X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811102X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811103X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811104X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811105X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811106X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811107X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811108X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811109X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811110X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811111X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811112X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1811113X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1811114X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD - RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         24 "24 ALTERNATIVE CARE PROVIDER"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H1811115X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811116X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811117X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1811118X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1811119X
         1 "1 YES"
         2 "2 NO" ;

label define H1811120X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811121X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811122X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811123X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811124X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811125X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1811126X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811127X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1811128X
         0 "0.00"
         500 "$1 - $500" ;

label define H1811129X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1811130X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811131X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811132X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811133X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811135X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811136X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811137X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811144X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1811145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1811147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1811148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1811149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1811150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1811151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1811152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1811153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1811154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1811155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1811156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1811157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1811159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1811160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1811165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1811166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1811167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 NO HEALTH INSURANCE"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         15 "15 HEALTH-RELATED REASONS"
         16 "16 NEWBORN - NO DOCTOR YET"
         17 "17 SELF, RELATIVE, OR FRIEND IS A DOCTOR"
         19 "19 CARE AVAILABLE ON JOB"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         22 "22 GOES TO HOSPITAL/EMERGENCY ROOM/CLINIC"
         23 "23 USES ALTERNATIVE CARE"
         24 "24 INSURANCE-RELATED REASONS"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H1811168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 1 YEAR"
         2 "2 1 YR., LESS THAN 5 YRS."
         3 "3 5 YRS., LESS THAN 10 YRS."
         4 "4 10 YRS., LESS THAN 15 YRS."
         5 "5 15 YEARS OR MORE" ;

label define H1811169X
         0 "0.00"
         12 "$1 - $12" ;

label define H1811170X
         0 "0.00"
         1625 "$1 - $1,625" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H1810001X;
label value ACTDTY31 H1810002X;
label value ACTDTY42 H1810003X;
label value ACTDTY53 H1810004X;
label value ACTLIM31 H1810005X;
label value ACTLIM53 H1810006X;
label value ADAPPT42 H1810007X;
label value ADCAPE42 H1810008X;
label value ADCLIM42 H1810009X;
label value ADCMPM42 H1810010X;
label value ADCMPY42 H1810011X;
label value ADDAYA42 H1810012X;
label value ADDOWN42 H1810013X;
label value ADDPRS42 H1810014X;
label value ADDRBP42 H1810015X;
label value ADEFRT42 H1810016X;
label value ADEGMC42 H1810017X;
label value ADESSP42 H1810018X;
label value ADEXPL42 H1810019X;
label value ADEZUN42 H1810020X;
label value ADFFRM42 H1810021X;
label value ADFHLP42 H1810022X;
label value ADGENH42 H1810023X;
label value ADHDADDX H1810024X;
label value ADHDAGED H1810025X;
label value ADHECR42 H1810026X;
label value ADHOPE42 H1810027X;
label value ADILCR42 H1810028X;
label value ADILWW42 H1810029X;
label value ADINSA42 H1810030X;
label value ADINSB42 H1810031X;
label value ADINST42 H1810032X;
label value ADINTR42 H1810033X;
label value ADLANG42 H1810034X;
label value ADLHLP31 H1810035X;
label value ADLHLP53 H1810036X;
label value ADLIST42 H1810037X;
label value ADMALS42 H1810038X;
label value ADMWLM42 H1810039X;
label value ADNDCR42 H1810040X;
label value ADNERV42 H1810041X;
label value ADNRGY42 H1810042X;
label value ADNSMK42 H1810043X;
label value ADOVER42 H1810044X;
label value ADPAIN42 H1810045X;
label value ADPALS42 H1810046X;
label value ADPRTM42 H1810047X;
label value ADPRXY42 H1810048X;
label value ADPWLM42 H1810049X;
label value ADRESP42 H1810050X;
label value ADREST42 H1810051X;
label value ADRISK42 H1810052X;
label value ADRTCR42 H1810053X;
label value ADRTWW42 H1810054X;
label value ADSAD42 H1810055X;
label value ADSMOK42 H1810056X;
label value ADSOCA42 H1810057X;
label value ADSPEC42 H1810058X;
label value ADTLHW42 H1810059X;
label value ADUPRO42 H1810060X;
label value ADWRTH42 H1810061X;
label value AFDC15 H1810062X;
label value AFTHOU42 H1810063X;
label value AIDHLP31 H1810064X;
label value AIDHLP53 H1810065X;
label value ALIIMP15 H1810066X;
label value AMCOFD15 H1810067X;
label value ANGIAGED H1810068X;
label value ANGIDX H1810069X;
label value ANYLMT15 H1810070X;
label value ARTHAGED H1810071X;
label value ARTHDX H1810072X;
label value ARTHTYPE H1810073X;
label value ASACUT53 H1810074X;
label value ASATAK31 H1810075X;
label value ASATAK53 H1810076X;
label value ASDALY53 H1810077X;
label value ASEVFL53 H1810078X;
label value ASIANP42 H1810079X;
label value ASMRCN53 H1810080X;
label value ASPKFL53 H1810081X;
label value ASPREV53 H1810082X;
label value ASPRIN53 H1810083X;
label value ASSTIL31 H1810084X;
label value ASSTIL53 H1810085X;
label value ASTHAGED H1810086X;
label value ASTHDX H1810087X;
label value ASTHEP31 H1810088X;
label value ASTHEP53 H1810089X;
label value ASWNFL53 H1810090X;
label value BEGRFM31 H1810091X;
label value BEGRFM42 H1810092X;
label value BEGRFM53 H1810093X;
label value BEGRFY31 H1810094X;
label value BEGRFY42 H1810095X;
label value BEGRFY53 H1810096X;
label value BENDIF31 H1810097X;
label value BENDIF53 H1810098X;
label value BLCKPR42 H1810099X;
label value BLIND42 H1810100X;
label value BMINDX53 H1810101X;
label value BOOST42 H1810102X;
label value BORNUSA H1810103X;
label value BPCHEK53 H1810104X;
label value BPMLDX H1810105X;
label value BRSTEX53 H1810106X;
label value BSNTY31 H1810107X;
label value BSNTY31H H1810108X;
label value BSNTY42 H1810109X;
label value BSNTY42H H1810110X;
label value BSNTY53 H1810111X;
label value BSNTY53H H1810112X;
label value BSTSRE53 H1810113X;
label value BSTST53 H1810114X;
label value BUSIMP15 H1810115X;
label value CABLADDR H1810116X;
label value CABREAST H1810117X;
label value CACERVIX H1810118X;
label value CACOLON H1810119X;
label value CALUNG H1810120X;
label value CALYMPH H1810121X;
label value CAMELANO H1810122X;
label value CANCERDX H1810123X;
label value CAOTHER H1810124X;
label value CAPROSTA H1810125X;
label value CARECO42 H1810126X;
label value CASKINDK H1810127X;
label value CASKINNM H1810128X;
label value CAUTERUS H1810129X;
label value CHAPPT42 H1810130X;
label value CHBMIX42 H1810131X;
label value CHBRON31 H1810132X;
label value CHBRON53 H1810133X;
label value CHCOUN42 H1810134X;
label value CHDAGED H1810135X;
label value CHDDX H1810136X;
label value CHECK53 H1810137X;
label value CHEMPB42 H1810138X;
label value CHENEC42 H1810139X;
label value CHEXPL42 H1810140X;
label value CHEYRE42 H1810141X;
label value CHGJ3142 H1810142X;
label value CHGJ4253 H1810143X;
label value CHHECR42 H1810144X;
label value CHILCR42 H1810145X;
label value CHILWW42 H1810146X;
label value CHLICO42 H1810147X;
label value CHLIHB42 H1810148X;
label value CHLIMI42 H1810149X;
label value CHLIMP15 H1810150X;
label value CHLIST42 H1810151X;
label value CHNDCR42 H1810152X;
label value CHOIC31 H1810153X;
label value CHOIC42 H1810154X;
label value CHOIC53 H1810155X;
label value CHOLAGED H1810156X;
label value CHOLCK53 H1810157X;
label value CHOLDX H1810158X;
label value CHPMCN42 H1810159X;
label value CHPMED42 H1810160X;
label value CHPMHB42 H1810161X;
label value CHPRTM42 H1810162X;
label value CHRESP42 H1810163X;
label value CHRTCR42 H1810164X;
label value CHRTWW42 H1810165X;
label value CHSERV42 H1810166X;
label value CHSPEC42 H1810167X;
label value CHSRCN42 H1810168X;
label value CHSRHB42 H1810169X;
label value CHTHCO42 H1810170X;
label value CHTHER42 H1810171X;
label value CHTHHB42 H1810172X;
label value CLINIC42 H1810173X;
label value CLMDEP15 H1810174X;
label value CLMHIP15 H1810175X;
label value CLNTRE53 H1810176X;
label value CLNTST53 H1810177X;
label value CMJHLD31 H1810178X;
label value CMJHLD42 H1810179X;
label value CMJHLD53 H1810180X;
label value COGLIM31 H1810181X;
label value COGLIM53 H1810182X;
label value COVRMM H1810183X;
label value COVRYY H1810184X;
label value CRFMPY42 H1810185X;
label value CSHCN42 H1810186X;
label value CSHIMP15 H1810187X;
label value DADPRO42 H1810188X;
label value DDNSCL15 H1810189X;
label value DDNWRK15 H1810190X;
label value DEAF42 H1810191X;
label value DECIDE42 H1810192X;
label value DENTAL42 H1810193X;
label value DENTCK53 H1810194X;
label value DENTIN31 H1810195X;
label value DENTIN42 H1810196X;
label value DENTIN53 H1810197X;
label value DEPDNT15 H1810198X;
label value DFCOG42 H1810199X;
label value DFDRSB42 H1810200X;
label value DFERND42 H1810201X;
label value DFHEAR42 H1810202X;
label value DFSEE42 H1810203X;
label value DFWLKC42 H1810204X;
label value DIABAGED H1810205X;
label value DIABDX H1810206X;
label value DIFFPL42 H1810207X;
label value DIFFWG31 H1810208X;
label value DIFFWG42 H1810209X;
label value DIFFWG53 H1810210X;
label value DISVW31X H1810211X;
label value DISVW42X H1810212X;
label value DISVW53X H1810213X;
label value DIVIMP15 H1810214X;
label value DKWHRU42 H1810215X;
label value DNDLAY42 H1810216X;
label value DNDLRS42 H1810217X;
label value DNTINS15 H1810218X;
label value DNTINS31 H1810219X;
label value DNUNAB42 H1810220X;
label value DNUNRS42 H1810221X;
label value DOBMM H1810222X;
label value DOBYY H1810223X;
label value DOCELS42 H1810224X;
label value DPINRU15 H1810225X;
label value DPOTSD15 H1810226X;
label value DSA1C53 H1810227X;
label value DSCB1453 H1810228X;
label value DSCGRP53 H1810229X;
label value DSCH1453 H1810230X;
label value DSCH1553 H1810231X;
label value DSCH1653 H1810232X;
label value DSCHNV53 H1810233X;
label value DSCINT53 H1810234X;
label value DSCNPC53 H1810235X;
label value DSCONF53 H1810236X;
label value DSCPCP53 H1810237X;
label value DSCPHN53 H1810238X;
label value DSDIA53 H1810239X;
label value DSDIET53 H1810240X;
label value DSEB1453 H1810241X;
label value DSEY1453 H1810242X;
label value DSEY1553 H1810243X;
label value DSEY1653 H1810244X;
label value DSEYNV53 H1810245X;
label value DSEYPR53 H1810246X;
label value DSFB1453 H1810247X;
label value DSFL1453 H1810248X;
label value DSFL1553 H1810249X;
label value DSFL1653 H1810250X;
label value DSFLNV53 H1810251X;
label value DSFT1453 H1810252X;
label value DSFT1553 H1810253X;
label value DSFT1653 H1810254X;
label value DSFTNV53 H1810255X;
label value DSINSU53 H1810256X;
label value DSKIDN53 H1810257X;
label value DSMED53 H1810258X;
label value DSPRX53 H1810259X;
label value DSVB1453 H1810260X;
label value DVGEN15 H1810261X;
label value DVOOPU15 H1810262X;
label value DVORTH15 H1810263X;
label value DVTOT15 H1810264X;
label value EATHLT42 H1810265X;
label value EDRECODE H1810266X;
label value EDUCYR H1810267X;
label value EDUYRDG H1810268X;
label value EICRDT15 H1810269X;
label value ELGRND15 H1810270X;
label value ELGRND31 H1810271X;
label value ELGRND42 H1810272X;
label value ELGRND53 H1810273X;
label value EMPHAGED H1810274X;
label value EMPHDX H1810275X;
label value EMPST31 H1810276X;
label value EMPST31H H1810277X;
label value EMPST42 H1810278X;
label value EMPST42H H1810279X;
label value EMPST53 H1810280X;
label value EMPST53H H1810281X;
label value ENDRFM15 H1810282X;
label value ENDRFM31 H1810283X;
label value ENDRFM42 H1810284X;
label value ENDRFM53 H1810285X;
label value ENDRFY15 H1810286X;
label value ENDRFY31 H1810287X;
label value ENDRFY42 H1810288X;
label value ENDRFY53 H1810289X;
label value ERTOT15 H1810290X;
label value EVRETIRE H1810291X;
label value EVRWRK H1810292X;
label value EXPLOP42 H1810293X;
label value EXRCIS53 H1810294X;
label value FAMRFPYR H1810295X;
label value FAMSZE31 H1810296X;
label value FAMSZE42 H1810297X;
label value FAMSZE53 H1810298X;
label value FCRP1231 H1810299X;
label value FILEDR15 H1810300X;
label value FILER15 H1810301X;
label value FLSTAT15 H1810302X;
label value FLUSHT53 H1810303X;
label value FMRS1231 H1810304X;
label value FNGRDF31 H1810305X;
label value FNGRDF53 H1810306X;
label value FOODMN15 H1810307X;
label value FOODST15 H1810308X;
label value FOODVL15 H1810309X;
label value FSAAMT31 H1810310X;
label value FSAGT31 H1810311X;
label value FTSTU15X H1810312X;
label value FTSTU31X H1810313X;
label value FTSTU42X H1810314X;
label value FTSTU53X H1810315X;
label value GENDRP42 H1810316X;
label value HASFSA31 H1810317X;
label value HAVEUS42 H1810318X;
label value HAVFUN42 H1810319X;
label value HEALTH42 H1810320X;
label value HEARAD42 H1810321X;
label value HELD31X H1810322X;
label value HELD42X H1810323X;
label value HELD53X H1810324X;
label value HELMET42 H1810325X;
label value HHAGD15 H1810326X;
label value HHINDD15 H1810327X;
label value HHINFD15 H1810328X;
label value HHNOSR15 H1810329X;
label value HHNTRI15 H1810330X;
label value HHTOTD15 H1810331X;
label value HIBPAGED H1810332X;
label value HIBPDX H1810333X;
label value HIDEG H1810334X;
label value HISPANX H1810335X;
label value HISPNCAT H1810336X;
label value HOMEBH42 H1810337X;
label value HONRDC31 H1810338X;
label value HONRDC42 H1810339X;
label value HONRDC53 H1810340X;
label value HOUR31 H1810341X;
label value HOUR42 H1810342X;
label value HOUR53 H1810343X;
label value HPDAP15 H1810344X;
label value HPDAU15 H1810345X;
label value HPDDE15 H1810346X;
label value HPDFE15 H1810347X;
label value HPDJA15 H1810348X;
label value HPDJL15 H1810349X;
label value HPDJU15 H1810350X;
label value HPDMA15 H1810351X;
label value HPDMY15 H1810352X;
label value HPDNO15 H1810353X;
label value HPDOC15 H1810354X;
label value HPDSE15 H1810355X;
label value HPEAP15 H1810356X;
label value HPEAU15 H1810357X;
label value HPEDE15 H1810358X;
label value HPEFE15 H1810359X;
label value HPEJA15 H1810360X;
label value HPEJL15 H1810361X;
label value HPEJU15 H1810362X;
label value HPEMA15 H1810363X;
label value HPEMY15 H1810364X;
label value HPENO15 H1810365X;
label value HPEOC15 H1810366X;
label value HPESE15 H1810367X;
label value HPNAP15 H1810368X;
label value HPNAU15 H1810369X;
label value HPNDE15 H1810370X;
label value HPNFE15 H1810371X;
label value HPNJA15 H1810372X;
label value HPNJL15 H1810373X;
label value HPNJU15 H1810374X;
label value HPNMA15 H1810375X;
label value HPNMY15 H1810376X;
label value HPNNO15 H1810377X;
label value HPNOC15 H1810378X;
label value HPNSE15 H1810379X;
label value HPOAP15 H1810380X;
label value HPOAU15 H1810381X;
label value HPODE15 H1810382X;
label value HPOFE15 H1810383X;
label value HPOJA15 H1810384X;
label value HPOJL15 H1810385X;
label value HPOJU15 H1810386X;
label value HPOMA15 H1810387X;
label value HPOMY15 H1810388X;
label value HPONO15 H1810389X;
label value HPOOC15 H1810390X;
label value HPOSE15 H1810391X;
label value HPRAP15 H1810392X;
label value HPRAU15 H1810393X;
label value HPRDE15 H1810394X;
label value HPRFE15 H1810395X;
label value HPRJA15 H1810396X;
label value HPRJL15 H1810397X;
label value HPRJU15 H1810398X;
label value HPRMA15 H1810399X;
label value HPRMY15 H1810400X;
label value HPRNO15 H1810401X;
label value HPROC15 H1810402X;
label value HPRSE15 H1810403X;
label value HPSAP15 H1810404X;
label value HPSAU15 H1810405X;
label value HPSDE15 H1810406X;
label value HPSFE15 H1810407X;
label value HPSJA15 H1810408X;
label value HPSJL15 H1810409X;
label value HPSJU15 H1810410X;
label value HPSMA15 H1810411X;
label value HPSMY15 H1810412X;
label value HPSNO15 H1810413X;
label value HPSOC15 H1810414X;
label value HPSSE15 H1810415X;
label value HPXAP15 H1810416X;
label value HPXAU15 H1810417X;
label value HPXDE15 H1810418X;
label value HPXFE15 H1810419X;
label value HPXJA15 H1810420X;
label value HPXJL15 H1810421X;
label value HPXJU15 H1810422X;
label value HPXMA15 H1810423X;
label value HPXMY15 H1810424X;
label value HPXNO15 H1810425X;
label value HPXOC15 H1810426X;
label value HPXSE15 H1810427X;
label value HRHOW31 H1810428X;
label value HRHOW42 H1810429X;
label value HRHOW53 H1810430X;
label value HRWG31H H1810431X;
label value HRWG31X H1810432X;
label value HRWG42H H1810433X;
label value HRWG42X H1810434X;
label value HRWG53H H1810435X;
label value HRWG53X H1810436X;
label value HRWGIM31 H1810437X;
label value HRWGIM42 H1810438X;
label value HRWGIM53 H1810439X;
label value HSELIM31 H1810440X;
label value HSELIM53 H1810441X;
label value HSPLAP42 H1810442X;
label value HWELLSPE H1810443X;
label value HYSTER53 H1810444X;
label value IADLHP31 H1810445X;
label value IADLHP53 H1810446X;
label value INDCAT31 H1810447X;
label value INDCAT42 H1810448X;
label value INDCAT53 H1810449X;
label value INDCT31H H1810450X;
label value INDCT42H H1810451X;
label value INDCT53H H1810452X;
label value INS15X H1810453X;
label value INS31X H1810454X;
label value INS42X H1810455X;
label value INS53X H1810456X;
label value INSAP15X H1810457X;
label value INSAT15X H1810458X;
label value INSAT31X H1810459X;
label value INSAT42X H1810460X;
label value INSAT53X H1810461X;
label value INSAU15X H1810462X;
label value INSC1231 H1810463X;
label value INSCOP15 H1810464X;
label value INSCOP31 H1810465X;
label value INSCOP42 H1810466X;
label value INSCOP53 H1810467X;
label value INSCOPE H1810468X;
label value INSCOV15 H1810469X;
label value INSDE15X H1810470X;
label value INSENDMM H1810471X;
label value INSENDYY H1810472X;
label value INSFE15X H1810473X;
label value INSJA15X H1810474X;
label value INSJL15X H1810475X;
label value INSJU15X H1810476X;
label value INSMA15X H1810477X;
label value INSMY15X H1810478X;
label value INSNO15X H1810479X;
label value INSOC15X H1810480X;
label value INSRPL42 H1810481X;
label value INSSE15X H1810482X;
label value INSURC15 H1810483X;
label value INTIMP15 H1810484X;
label value INTVLANG H1810485X;
label value IPDIS15 H1810486X;
label value IPZERO15 H1810487X;
label value IRAIMP15 H1810488X;
label value JBORG31H H1810489X;
label value JBORG42H H1810490X;
label value JBORG53H H1810491X;
label value JNTPID15 H1810492X;
label value JOBORG31 H1810493X;
label value JOBORG42 H1810494X;
label value JOBORG53 H1810495X;
label value JOBRSN42 H1810496X;
label value JTINRU15 H1810497X;
label value JTPAIN31 H1810498X;
label value JTPAIN53 H1810499X;
label value K6SUM42 H1810500X;
label value KEYNESS H1810501X;
label value KIDPRO42 H1810502X;
label value KNOWDR42 H1810503X;
label value LANGSPK H1810504X;
label value LAPBLT42 H1810505X;
label value LFTDIF31 H1810506X;
label value LFTDIF53 H1810507X;
label value LOCATN42 H1810508X;
label value LSTETH53 H1810509X;
label value MAMOGR53 H1810510X;
label value MARRY15X H1810511X;
label value MARRY31X H1810512X;
label value MARRY42X H1810513X;
label value MARRY53X H1810514X;
label value MCAID15 H1810515X;
label value MCAID15X H1810516X;
label value MCAID31 H1810517X;
label value MCAID31X H1810518X;
label value MCAID42 H1810519X;
label value MCAID42X H1810520X;
label value MCAID53 H1810521X;
label value MCAID53X H1810522X;
label value MCARE15 H1810523X;
label value MCARE15X H1810524X;
label value MCARE31 H1810525X;
label value MCARE31X H1810526X;
label value MCARE42 H1810527X;
label value MCARE42X H1810528X;
label value MCARE53 H1810529X;
label value MCARE53X H1810530X;
label value MCDAP15 H1810531X;
label value MCDAP15X H1810532X;
label value MCDAT15X H1810533X;
label value MCDAT31X H1810534X;
label value MCDAT42X H1810535X;
label value MCDAT53X H1810536X;
label value MCDAU15 H1810537X;
label value MCDAU15X H1810538X;
label value MCDDE15 H1810539X;
label value MCDDE15X H1810540X;
label value MCDEV15 H1810541X;
label value MCDFE15 H1810542X;
label value MCDFE15X H1810543X;
label value MCDHMO15 H1810544X;
label value MCDHMO31 H1810545X;
label value MCDHMO42 H1810546X;
label value MCDJA15 H1810547X;
label value MCDJA15X H1810548X;
label value MCDJL15 H1810549X;
label value MCDJL15X H1810550X;
label value MCDJU15 H1810551X;
label value MCDJU15X H1810552X;
label value MCDMA15 H1810553X;
label value MCDMA15X H1810554X;
label value MCDMC15 H1810555X;
label value MCDMC31 H1810556X;
label value MCDMC42 H1810557X;
label value MCDMY15 H1810558X;
label value MCDMY15X H1810559X;
label value MCDNO15 H1810560X;
label value MCDNO15X H1810561X;
label value MCDOC15 H1810562X;
label value MCDOC15X H1810563X;
label value MCDSE15 H1810564X;
label value MCDSE15X H1810565X;
label value MCRAP15 H1810566X;
label value MCRAP15X H1810567X;
label value MCRAU15 H1810568X;
label value MCRAU15X H1810569X;
label value MCRDE15 H1810570X;
label value MCRDE15X H1810571X;
label value MCREV15 H1810572X;
label value MCRFE15 H1810573X;
label value MCRFE15X H1810574X;
label value MCRJA15 H1810575X;
label value MCRJA15X H1810576X;
label value MCRJL15 H1810577X;
label value MCRJL15X H1810578X;
label value MCRJU15 H1810579X;
label value MCRJU15X H1810580X;
label value MCRMA15 H1810581X;
label value MCRMA15X H1810582X;
label value MCRMY15 H1810583X;
label value MCRMY15X H1810584X;
label value MCRNO15 H1810585X;
label value MCRNO15X H1810586X;
label value MCROC15 H1810587X;
label value MCROC15X H1810588X;
label value MCRPB15 H1810589X;
label value MCRPB31 H1810590X;
label value MCRPB42 H1810591X;
label value MCRPD15 H1810592X;
label value MCRPD15X H1810593X;
label value MCRPD31 H1810594X;
label value MCRPD31X H1810595X;
label value MCRPD42 H1810596X;
label value MCRPD42X H1810597X;
label value MCRPHO15 H1810598X;
label value MCRPHO31 H1810599X;
label value MCRPHO42 H1810600X;
label value MCRSE15 H1810601X;
label value MCRSE15X H1810602X;
label value MDDLAY42 H1810603X;
label value MDDLRS42 H1810604X;
label value MDUNAB42 H1810605X;
label value MDUNRS42 H1810606X;
label value MESBPR42 H1810607X;
label value MESHGT42 H1810608X;
label value MESVIS42 H1810609X;
label value MESWGT42 H1810610X;
label value MIAGED H1810611X;
label value MIDX H1810612X;
label value MILDIF31 H1810613X;
label value MILDIF53 H1810614X;
label value MINORP42 H1810615X;
label value MNHLTH31 H1810616X;
label value MNHLTH42 H1810617X;
label value MNHLTH53 H1810618X;
label value MOMPRO42 H1810619X;
label value MORE31 H1810620X;
label value MORE31H H1810621X;
label value MORE42 H1810622X;
label value MORE42H H1810623X;
label value MORE53 H1810624X;
label value MORE53H H1810625X;
label value MORECOVR H1810626X;
label value MORJOB31 H1810627X;
label value MORJOB42 H1810628X;
label value MORJOB53 H1810629X;
label value MYSELF42 H1810630X;
label value NATAMP42 H1810631X;
label value NERVAF42 H1810632X;
label value NEWARE42 H1810633X;
label value NEWDOC42 H1810634X;
label value NHRWG31 H1810635X;
label value NHRWG42 H1810636X;
label value NHRWG53 H1810637X;
label value NOASPR53 H1810638X;
label value NOFAT53 H1810639X;
label value NOGODR42 H1810640X;
label value NOHINS42 H1810641X;
label value NOINSBEF H1810642X;
label value NOINSTM H1810643X;
label value NOINUNIT H1810644X;
label value NOLIKE42 H1810645X;
label value NOREAS42 H1810646X;
label value NOSMOK42 H1810647X;
label value NUMEMP31 H1810648X;
label value NUMEMP42 H1810649X;
label value NUMEMP53 H1810650X;
label value NWK31 H1810651X;
label value NWK42 H1810652X;
label value NWK53 H1810653X;
label value OBASST15 H1810654X;
label value OBCHIR15 H1810655X;
label value OBDRV15 H1810656X;
label value OBNURS15 H1810657X;
label value OBOPTO15 H1810658X;
label value OBOTHV15 H1810659X;
label value OBTHER15 H1810660X;
label value OBTOTV15 H1810661X;
label value OCCCAT31 H1810662X;
label value OCCCAT42 H1810663X;
label value OCCCAT53 H1810664X;
label value OCCCT31H H1810665X;
label value OCCCT42H H1810666X;
label value OCCCT53H H1810667X;
label value OFEMP31H H1810668X;
label value OFEMP42H H1810669X;
label value OFEMP53H H1810670X;
label value OFFER31H H1810671X;
label value OFFER31X H1810672X;
label value OFFER42H H1810673X;
label value OFFER42X H1810674X;
label value OFFER53H H1810675X;
label value OFFER53X H1810676X;
label value OFFHOU42 H1810677X;
label value OFREMP31 H1810678X;
label value OFREMP42 H1810679X;
label value OFREMP53 H1810680X;
label value OHRTAGED H1810681X;
label value OHRTDX H1810682X;
label value ONGONG42 H1810683X;
label value ONJOB42 H1810684X;
label value OPAAP15 H1810685X;
label value OPAAU15 H1810686X;
label value OPADE15 H1810687X;
label value OPAEV15 H1810688X;
label value OPAFE15 H1810689X;
label value OPAJA15 H1810690X;
label value OPAJL15 H1810691X;
label value OPAJU15 H1810692X;
label value OPAMA15 H1810693X;
label value OPAMY15 H1810694X;
label value OPANO15 H1810695X;
label value OPAOC15 H1810696X;
label value OPASE15 H1810697X;
label value OPBAP15 H1810698X;
label value OPBAU15 H1810699X;
label value OPBDE15 H1810700X;
label value OPBEV15 H1810701X;
label value OPBFE15 H1810702X;
label value OPBJA15 H1810703X;
label value OPBJL15 H1810704X;
label value OPBJU15 H1810705X;
label value OPBMA15 H1810706X;
label value OPBMY15 H1810707X;
label value OPBNO15 H1810708X;
label value OPBOC15 H1810709X;
label value OPBSE15 H1810710X;
label value OPDOFD15 H1810711X;
label value OPDRV15 H1810712X;
label value OPOTHV15 H1810713X;
label value OPPOFD15 H1810714X;
label value OPSOFD15 H1810715X;
label value OPTOTV15 H1810716X;
label value OTHDYS15 H1810717X;
label value OTHIMP15 H1810718X;
label value OTHINS42 H1810719X;
label value OTHLANG H1810720X;
label value OTHNDD15 H1810721X;
label value OTHOFD15 H1810722X;
label value OTHRCP42 H1810723X;
label value OTHREA42 H1810724X;
label value OTPAAT15 H1810725X;
label value OTPAAT31 H1810726X;
label value OTPAAT42 H1810727X;
label value OTPAAT53 H1810728X;
label value OTPBAT15 H1810729X;
label value OTPBAT31 H1810730X;
label value OTPBAT42 H1810731X;
label value OTPBAT53 H1810732X;
label value OTPUBA15 H1810733X;
label value OTPUBA31 H1810734X;
label value OTPUBA42 H1810735X;
label value OTPUBA53 H1810736X;
label value OTPUBB15 H1810737X;
label value OTPUBB31 H1810738X;
label value OTPUBB42 H1810739X;
label value OTPUBB53 H1810740X;
label value PACISP42 H1810741X;
label value PANEL H1810742X;
label value PAPSMR53 H1810743X;
label value PAYDR31 H1810744X;
label value PAYDR31H H1810745X;
label value PAYDR42 H1810746X;
label value PAYDR42H H1810747X;
label value PAYDR53 H1810748X;
label value PAYDR53H H1810749X;
label value PAYVAC31 H1810750X;
label value PAYVAC42 H1810751X;
label value PAYVAC53 H1810752X;
label value PDKAP15 H1810753X;
label value PDKAU15 H1810754X;
label value PDKDE15 H1810755X;
label value PDKFE15 H1810756X;
label value PDKJA15 H1810757X;
label value PDKJL15 H1810758X;
label value PDKJU15 H1810759X;
label value PDKMA15 H1810760X;
label value PDKMY15 H1810761X;
label value PDKNO15 H1810762X;
label value PDKOC15 H1810763X;
label value PDKSE15 H1810764X;
label value PEGAP15 H1810765X;
label value PEGAU15 H1810766X;
label value PEGDE15 H1810767X;
label value PEGFE15 H1810768X;
label value PEGJA15 H1810769X;
label value PEGJL15 H1810770X;
label value PEGJU15 H1810771X;
label value PEGMA15 H1810772X;
label value PEGMY15 H1810773X;
label value PEGNO15 H1810774X;
label value PEGOC15 H1810775X;
label value PEGSE15 H1810776X;
label value PENIMP15 H1810777X;
label value PERSLA42 H1810778X;
label value PHNREG42 H1810779X;
label value PHQ242 H1810780X;
label value PHYEXE53 H1810781X;
label value PHYSCL42 H1810782X;
label value PLCTYP42 H1810783X;
label value PMDINS15 H1810784X;
label value PMDINS31 H1810785X;
label value PMDLAY42 H1810786X;
label value PMDLRS42 H1810787X;
label value PMEDIN31 H1810788X;
label value PMEDIN42 H1810789X;
label value PMEDIN53 H1810790X;
label value PMEDPY31 H1810791X;
label value PMEDPY42 H1810792X;
label value PMEDPY53 H1810793X;
label value PMEDUP31 H1810794X;
label value PMEDUP42 H1810795X;
label value PMEDUP53 H1810796X;
label value PMUNAB42 H1810797X;
label value PMUNRS42 H1810798X;
label value PNGAP15 H1810799X;
label value PNGAU15 H1810800X;
label value PNGDE15 H1810801X;
label value PNGFE15 H1810802X;
label value PNGJA15 H1810803X;
label value PNGJL15 H1810804X;
label value PNGJU15 H1810805X;
label value PNGMA15 H1810806X;
label value PNGMY15 H1810807X;
label value PNGNO15 H1810808X;
label value PNGOC15 H1810809X;
label value PNGSE15 H1810810X;
label value POGAP15 H1810811X;
label value POGAU15 H1810812X;
label value POGDE15 H1810813X;
label value POGFE15 H1810814X;
label value POGJA15 H1810815X;
label value POGJL15 H1810816X;
label value POGJU15 H1810817X;
label value POGMA15 H1810818X;
label value POGMY15 H1810819X;
label value POGNO15 H1810820X;
label value POGOC15 H1810821X;
label value POGSE15 H1810822X;
label value POUAP15 H1810823X;
label value POUAU15 H1810824X;
label value POUDE15 H1810825X;
label value POUFE15 H1810826X;
label value POUJA15 H1810827X;
label value POUJL15 H1810828X;
label value POUJU15 H1810829X;
label value POUMA15 H1810830X;
label value POUMY15 H1810831X;
label value POUNO15 H1810832X;
label value POUOC15 H1810833X;
label value POUSE15 H1810834X;
label value POVCAT15 H1810835X;
label value PREGNT31 H1810836X;
label value PREGNT42 H1810837X;
label value PREGNT53 H1810838X;
label value PREVCOVR H1810839X;
label value PREVEN42 H1810840X;
label value PRIAP15 H1810841X;
label value PRIAU15 H1810842X;
label value PRIDE15 H1810843X;
label value PRIDK15 H1810844X;
label value PRIDK31 H1810845X;
label value PRIDK42 H1810846X;
label value PRIDK53 H1810847X;
label value PRIEU15 H1810848X;
label value PRIEU31 H1810849X;
label value PRIEU42 H1810850X;
label value PRIEU53 H1810851X;
label value PRIFE15 H1810852X;
label value PRIJA15 H1810853X;
label value PRIJL15 H1810854X;
label value PRIJU15 H1810855X;
label value PRIMA15 H1810856X;
label value PRIMY15 H1810857X;
label value PRING15 H1810858X;
label value PRING31 H1810859X;
label value PRING42 H1810860X;
label value PRING53 H1810861X;
label value PRINO15 H1810862X;
label value PRIOC15 H1810863X;
label value PRIOG15 H1810864X;
label value PRIOG31 H1810865X;
label value PRIOG42 H1810866X;
label value PRIOG53 H1810867X;
label value PRIS15 H1810868X;
label value PRIS31 H1810869X;
label value PRIS42 H1810870X;
label value PRIS53 H1810871X;
label value PRISE15 H1810872X;
label value PRIV15 H1810873X;
label value PRIV31 H1810874X;
label value PRIV42 H1810875X;
label value PRIV53 H1810876X;
label value PRIVAT15 H1810877X;
label value PRIVAT31 H1810878X;
label value PRIVAT42 H1810879X;
label value PRIVAT53 H1810880X;
label value PROBPY42 H1810881X;
label value PROUT15 H1810882X;
label value PROUT31 H1810883X;
label value PROUT42 H1810884X;
label value PROUT53 H1810885X;
label value PROVTY42 H1810886X;
label value PROXY15 H1810887X;
label value PROXY31 H1810888X;
label value PROXY42 H1810889X;
label value PROXY53 H1810890X;
label value PRSAP15 H1810891X;
label value PRSAU15 H1810892X;
label value PRSDE15 H1810893X;
label value PRSFE15 H1810894X;
label value PRSJA15 H1810895X;
label value PRSJL15 H1810896X;
label value PRSJU15 H1810897X;
label value PRSMA15 H1810898X;
label value PRSMY15 H1810899X;
label value PRSNO15 H1810900X;
label value PRSOC15 H1810901X;
label value PRSSE15 H1810902X;
label value PRSTX15 H1810903X;
label value PRSTX31 H1810904X;
label value PRSTX42 H1810905X;
label value PRSTX53 H1810906X;
label value PRVEV15 H1810907X;
label value PRVHMO15 H1810908X;
label value PRVHMO31 H1810909X;
label value PRVHMO42 H1810910X;
label value PRVSPK42 H1810911X;
label value PRXAP15 H1810912X;
label value PRXAU15 H1810913X;
label value PRXDE15 H1810914X;
label value PRXFE15 H1810915X;
label value PRXJA15 H1810916X;
label value PRXJL15 H1810917X;
label value PRXJU15 H1810918X;
label value PRXMA15 H1810919X;
label value PRXMY15 H1810920X;
label value PRXNO15 H1810921X;
label value PRXOC15 H1810922X;
label value PRXSE15 H1810923X;
label value PSA53 H1810924X;
label value PSTATS31 H1810925X;
label value PSTATS42 H1810926X;
label value PSTATS53 H1810927X;
label value PUB15X H1810928X;
label value PUB31X H1810929X;
label value PUB42X H1810930X;
label value PUB53X H1810931X;
label value PUBAP15X H1810932X;
label value PUBAT15X H1810933X;
label value PUBAT31X H1810934X;
label value PUBAT42X H1810935X;
label value PUBAT53X H1810936X;
label value PUBAU15X H1810937X;
label value PUBDE15X H1810938X;
label value PUBFE15X H1810939X;
label value PUBIMP15 H1810940X;
label value PUBJA15X H1810941X;
label value PUBJL15X H1810942X;
label value PUBJU15X H1810943X;
label value PUBMA15X H1810944X;
label value PUBMY15X H1810945X;
label value PUBNO15X H1810946X;
label value PUBOC15X H1810947X;
label value PUBSE15X H1810948X;
label value PYUNBL42 H1810949X;
label value PYVAC31H H1810950X;
label value PYVAC42H H1810951X;
label value PYVAC53H H1810952X;
label value RACEAX H1810953X;
label value RACEBX H1810954X;
label value RACETHX H1810955X;
label value RACEV1X H1810956X;
label value RACEV2X H1810957X;
label value RACEWX H1810958X;
label value RCHDIF31 H1810959X;
label value RCHDIF53 H1810960X;
label value REFFRL42 H1810961X;
label value REFRL15X H1810962X;
label value REFRL31X H1810963X;
label value REFRL42X H1810964X;
label value REFRL53X H1810965X;
label value REGION15 H1810966X;
label value REGION31 H1810967X;
label value REGION42 H1810968X;
label value REGION53 H1810969X;
label value RESP15 H1810970X;
label value RESP31 H1810971X;
label value RESP42 H1810972X;
label value RESP53 H1810973X;
label value RESPCT42 H1810974X;
label value RETPLN31 H1810975X;
label value RETPLN42 H1810976X;
label value RETPLN53 H1810977X;
label value RNDFLG31 H1810978X;
label value RTHLTH31 H1810979X;
label value RTHLTH42 H1810980X;
label value RTHLTH53 H1810981X;
label value RTPLN31H H1810982X;
label value RTPLN42H H1810983X;
label value RTPLN53H H1810984X;
label value RUCLAS15 H1810985X;
label value RUCLAS31 H1810986X;
label value RUCLAS42 H1810987X;
label value RUCLAS53 H1810988X;
label value RUSIZE15 H1810989X;
label value RUSIZE31 H1810990X;
label value RUSIZE42 H1810991X;
label value RUSIZE53 H1810992X;
label value SAFEST42 H1810993X;
label value SALIMP15 H1810994X;
label value SAQELIG H1810995X;
label value SCHLBH42 H1810996X;
label value SCHLIM31 H1810997X;
label value SCHLIM53 H1810998X;
label value SCHPRO42 H1810999X;
label value SCPAY31H H1811000X;
label value SCPAY42H H1811001X;
label value SCPAY53H H1811002X;
label value SEATBE53 H1811003X;
label value SELDSI42 H1811004X;
label value SELFCM31 H1811005X;
label value SELFCM42 H1811006X;
label value SELFCM53 H1811007X;
label value SEX H1811008X;
label value SFFLAG42 H1811009X;
label value SGMTRE53 H1811010X;
label value SGMTST53 H1811011X;
label value SIBPRO42 H1811012X;
label value SICPAY31 H1811013X;
label value SICPAY42 H1811014X;
label value SICPAY53 H1811015X;
label value SLFCM31H H1811016X;
label value SLFCM42H H1811017X;
label value SLFCM53H H1811018X;
label value SOCLIM31 H1811019X;
label value SOCLIM53 H1811020X;
label value SPOUID15 H1811021X;
label value SPOUID31 H1811022X;
label value SPOUID42 H1811023X;
label value SPOUID53 H1811024X;
label value SPOUIN15 H1811025X;
label value SPOUIN31 H1811026X;
label value SPOUIN42 H1811027X;
label value SPOUIN53 H1811028X;
label value SPRPRO42 H1811029X;
label value SSCIMP15 H1811030X;
label value SSIIMP15 H1811031X;
label value SSNLJB31 H1811032X;
label value SSNLJB42 H1811033X;
label value SSNLJB53 H1811034X;
label value STAAP15 H1811035X;
label value STAAU15 H1811036X;
label value STADE15 H1811037X;
label value STAFE15 H1811038X;
label value STAJA15 H1811039X;
label value STAJL15 H1811040X;
label value STAJU15 H1811041X;
label value STAMA15 H1811042X;
label value STAMY15 H1811043X;
label value STANO15 H1811044X;
label value STAOC15 H1811045X;
label value STAPR15 H1811046X;
label value STAPR31 H1811047X;
label value STAPR42 H1811048X;
label value STAPR53 H1811049X;
label value STASE15 H1811050X;
label value STJBMM31 H1811051X;
label value STJBMM42 H1811052X;
label value STJBMM53 H1811053X;
label value STJBYY31 H1811054X;
label value STJBYY42 H1811055X;
label value STJBYY53 H1811056X;
label value STNDIF31 H1811057X;
label value STNDIF53 H1811058X;
label value STOMCH53 H1811059X;
label value STPDIF31 H1811060X;
label value STPDIF53 H1811061X;
label value STPRAT15 H1811062X;
label value STPRAT31 H1811063X;
label value STPRAT42 H1811064X;
label value STPRAT53 H1811065X;
label value STRKAGED H1811066X;
label value STRKDX H1811067X;
label value TAXFRM15 H1811068X;
label value TEMPJB31 H1811069X;
label value TEMPJB42 H1811070X;
label value TEMPJB53 H1811071X;
label value TIMALN42 H1811072X;
label value TMTKUS42 H1811073X;
label value TRANS42 H1811074X;
label value TRBLE42 H1811075X;
label value TREATM42 H1811076X;
label value TRIAP15X H1811077X;
label value TRIAT15X H1811078X;
label value TRIAT31X H1811079X;
label value TRIAT42X H1811080X;
label value TRIAT53X H1811081X;
label value TRIAU15X H1811082X;
label value TRICH15X H1811083X;
label value TRICH31X H1811084X;
label value TRICH42X H1811085X;
label value TRICR15X H1811086X;
label value TRICR31X H1811087X;
label value TRICR42X H1811088X;
label value TRICR53X H1811089X;
label value TRIDE15X H1811090X;
label value TRIEV15 H1811091X;
label value TRIEX15X H1811092X;
label value TRIEX31X H1811093X;
label value TRIEX42X H1811094X;
label value TRIFE15X H1811095X;
label value TRIJA15X H1811096X;
label value TRIJL15X H1811097X;
label value TRIJU15X H1811098X;
label value TRILI15X H1811099X;
label value TRILI31X H1811100X;
label value TRILI42X H1811101X;
label value TRIMA15X H1811102X;
label value TRIMY15X H1811103X;
label value TRINO15X H1811104X;
label value TRIOC15X H1811105X;
label value TRIPR15X H1811106X;
label value TRIPR31X H1811107X;
label value TRIPR42X H1811108X;
label value TRISE15X H1811109X;
label value TRIST15X H1811110X;
label value TRIST31X H1811111X;
label value TRIST42X H1811112X;
label value TRTIMP15 H1811113X;
label value TYPEPE42 H1811114X;
label value UNABLE31 H1811115X;
label value UNABLE53 H1811116X;
label value UNEIMP15 H1811117X;
label value UNHAP42 H1811118X;
label value UNINS15 H1811119X;
label value UNION31 H1811120X;
label value UNION31H H1811121X;
label value UNION42 H1811122X;
label value UNION42H H1811123X;
label value UNION53 H1811124X;
label value UNION53H H1811125X;
label value USCNOT42 H1811126X;
label value VETIMP15 H1811127X;
label value VISWCP15 H1811128X;
label value WAGIMP15 H1811129X;
label value WASAFDC H1811130X;
label value WASCHAMP H1811131X;
label value WASESTB H1811132X;
label value WASMCAID H1811133X;
label value WASMCARE H1811134X;
label value WASOTGOV H1811135X;
label value WASOTHER H1811136X;
label value WASPRIV H1811137X;
label value WASSSI H1811138X;
label value WASSTAT1 H1811139X;
label value WASSTAT2 H1811140X;
label value WASSTAT3 H1811141X;
label value WASSTAT4 H1811142X;
label value WASVA H1811143X;
label value WCPIMP15 H1811144X;
label value WHITPR42 H1811145X;
label value WHNBPR42 H1811146X;
label value WHNBST42 H1811147X;
label value WHNDEN42 H1811148X;
label value WHNEAT42 H1811149X;
label value WHNHEL42 H1811150X;
label value WHNHGT42 H1811151X;
label value WHNLAP42 H1811152X;
label value WHNPHY42 H1811153X;
label value WHNSAF42 H1811154X;
label value WHNSMK42 H1811155X;
label value WHNWGT42 H1811156X;
label value WILFIL15 H1811157X;
label value WLKDIF31 H1811158X;
label value WLKDIF53 H1811159X;
label value WLKLIM31 H1811160X;
label value WLKLIM53 H1811161X;
label value WRGLAS42 H1811162X;
label value WRKLIM31 H1811163X;
label value WRKLIM53 H1811164X;
label value YCHJ3142 H1811165X;
label value YCHJ4253 H1811166X;
label value YNOUSC42 H1811167X;
label value YRSINUS H1811168X;
label value ZIDVA15 H1811169X;
label value ZIFOFD15 H1811170X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;

#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H181.LOG and a data file named H181.DTA.  If these files (H181.DTA and H181.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

